/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Type;

public class JavaObjectValue
extends AtomicValue {
    private Object object;

    public JavaObjectValue(Object object) {
        this.object = object;
    }

    public int getType() {
        return 100;
    }

    public Object getObject() {
        return this.object;
    }

    public String getStringValue() {
        return String.valueOf(this.object);
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        if (requiredType == 100) {
            return this;
        }
        throw new XPathException("cannot convert Java object to " + Type.getTypeName(requiredType));
    }

    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("Called effectiveBooleanValue() on JavaObjectValue");
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare Java object to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare Java object to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare Java objects");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare Java objects");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(this.object.getClass())) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(this.object.getClass())) {
            return this.object;
        }
        if (target == Object.class) {
            return this.object;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

