/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.ExistIOException;
import org.exist.validation.ValidationReport;
import org.exist.validation.ValidationReportItem;
import org.exist.validation.Validator;
import org.exist.validation.internal.node.NodeInputStream;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.helpers.AttributesImpl;

public class Validation
extends BasicFunction {
    private static final String simpleFunctionTxt = "Validate document specified by $a. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). The grammar files are resolved using the global catalog file(s).";
    private static final String extendedFunctionTxt = "Validate document specified by $a using $b. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). $b can point to an OASIS catalog file, a grammar (xml schema only) or a collection (path ends with '/')";
    private final Validator validator;
    private final BrokerPool brokerPool;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("validate", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $a. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). The grammar files are resolved using the global catalog file(s).", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(23, 2)), new FunctionSignature(new QName("validate", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $a using $b. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). $b can point to an OASIS catalog file, a grammar (xml schema only) or a collection (path ends with '/')", new SequenceType[]{new SequenceType(11, 2), new SequenceType(25, 2)}, new SequenceType(23, 2)), new FunctionSignature(new QName("validate-report", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $a. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). The grammar files are resolved using the global catalog file(s). A simple report is returned.", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(-1, 2)), new FunctionSignature(new QName("validate-report", "http://exist-db.org/xquery/validation", "validation"), "Validate document specified by $a using $b. $a is of type xs:anyURI, or a node (element or returned by fn:doc()). $b can point to an OASIS catalog file, a grammar (xml schema only) or a collection (path ends with '/') A simple report is returned.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(25, 2)}, new SequenceType(-1, 2))};

    public Validation(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.brokerPool = context.getBroker().getBrokerPool();
        this.validator = new Validator(this.brokerPool);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length != 1 && args.length != 2) {
            return Sequence.EMPTY_SEQUENCE;
        }
        InputStream is = null;
        ValidationReport vr = null;
        try {
            String url;
            if (args[0].getItemType() == 25 || args[0].getItemType() == 22) {
                url = args[0].getStringValue();
                if (url.startsWith("/")) {
                    url = "xmldb:exist://" + url;
                }
                is = new URL(url).openStream();
            } else if (args[0].getItemType() == 1 || args[0].getItemType() == 6) {
                is = new NodeInputStream(this.context, args[0].iterate());
            } else {
                LOG.error((Object)("Wrong item type " + Type.getTypeName(args[0].getItemType())));
                throw new XPathException(this.getASTNode(), "wrong item type " + Type.getTypeName(args[0].getItemType()));
            }
            if (args.length == 1) {
                vr = this.validator.validate(is);
            } else {
                url = args[1].getStringValue();
                if (url.startsWith("/")) {
                    url = "xmldb:exist://" + url;
                }
                vr = this.validator.validate(is, url);
            }
        }
        catch (MalformedURLException ex) {
            LOG.error((Object)ex);
            throw new XPathException(this.getASTNode(), "Invalid resource URI", ex);
        }
        catch (ExistIOException ex) {
            LOG.error((Object)ex.getCause());
            throw new XPathException(this.getASTNode(), "eXistIOexception", ex.getCause());
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            throw new XPathException(this.getASTNode(), "exception", ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.debug((Object)"Attemted to close stream. ignore.", (Throwable)ex);
            }
        }
        if (this.isCalledAs("validate")) {
            ValueSequence result = new ValueSequence();
            result.add(new BooleanValue(vr.isValid()));
            return result;
        }
        if (this.isCalledAs("validate-report")) {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            NodeImpl result = this.writeReport(vr, builder);
            return result;
        }
        LOG.error((Object)"invoked with wrong function name");
        throw new XPathException("unknown function");
    }

    private NodeImpl writeReport(ValidationReport report, MemTreeBuilder builder) {
        int nodeNr = builder.startElement("", "report", "report", null);
        builder.startElement("", "status", "status", null);
        if (report.isValid()) {
            builder.characters("valid");
        } else {
            builder.characters("invalid");
        }
        builder.endElement();
        if (report.getNamespaceUri() != null) {
            builder.startElement("", "namespace", "namespace", null);
            builder.characters(report.getNamespaceUri());
            builder.endElement();
        }
        builder.startElement("", "time", "time", null);
        builder.characters("" + report.getValidationDuration());
        builder.endElement();
        if (report.getThrowable() != null) {
            builder.startElement("", "exception", "exception", null);
            builder.characters("" + report.getThrowable().getMessage());
            builder.endElement();
        }
        AttributesImpl attribs = new AttributesImpl();
        List cr = report.getValidationReportItemList();
        Iterator iter = cr.iterator();
        while (iter.hasNext()) {
            ValidationReportItem vri = (ValidationReportItem)iter.next();
            attribs.addAttribute("", "level", "level", "CDATA", vri.getTypeText());
            attribs.addAttribute("", "line", "line", "CDATA", Integer.toString(vri.getLineNumber()));
            attribs.addAttribute("", "column", "column", "CDATA", Integer.toString(vri.getColumnNumber()));
            if (vri.getRepeat() > 1) {
                attribs.addAttribute("", "repeat", "repeat", "CDATA", Integer.toString(vri.getRepeat()));
            }
            builder.startElement("", "message", "message", attribs);
            builder.characters(vri.getMessage());
            builder.endElement();
            attribs.clear();
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }
}

