/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetAttribute
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-attribute", "http://exist-db.org/xquery/session", "session"), "Returns an attribute stored in the current session object or an empty sequence if the attribute cannot be found.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 7));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("get-session-attribute", "http://exist-db.org/xquery/request", "request"), "Returns an attribute stored in the current session object or an empty sequence if the attribute cannot be found.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 7), "Moved to 'session' module. Renamed to session:get-attribute");

    public GetAttribute(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException("Session not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException("Variable $session is not bound to a Java object.");
        }
        JavaObjectValue session = (JavaObjectValue)var.getValue().itemAt(0);
        String attribName = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        if (session.getObject() instanceof SessionWrapper) {
            try {
                Object o = ((SessionWrapper)session.getObject()).getAttribute(attribName);
                if (o == null) {
                    return Sequence.EMPTY_SEQUENCE;
                }
                return XPathUtil.javaObjectToXPath(o, this.context);
            }
            catch (IllegalStateException ise) {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        throw new XPathException("Type error: variable $session is not bound to a session object");
    }
}

