/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunGetDateComponent
extends BasicFunction {
    public static final FunctionSignature fnDayFromDate = new FunctionSignature(new QName("day-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $a.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMonthFromDate = new FunctionSignature(new QName("month-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $a.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnYearFromDate = new FunctionSignature(new QName("year-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnTimezoneFromDate = new FunctionSignature(new QName("timezone-from-date", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(51, 3)}, new SequenceType(55, 3));
    public static final FunctionSignature fnHoursFromTime = new FunctionSignature(new QName("hours-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $arg.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMinutesFromTime = new FunctionSignature(new QName("minutes-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $arg.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnSecondsFromTime = new FunctionSignature(new QName("seconds-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $arg. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(32, 3));
    public static final FunctionSignature fnTimezoneFromTime = new FunctionSignature(new QName("timezone-from-time", "http://www.w3.org/2005/xpath-functions"), "Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xdt:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.", new SequenceType[]{new SequenceType(52, 3)}, new SequenceType(55, 3));
    public static final FunctionSignature fnDayFromDateTime = new FunctionSignature(new QName("day-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 31, both inclusive, representing the day component in the localized value of $a.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMonthFromDateTime = new FunctionSignature(new QName("month-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 1 and 12, both inclusive, representing the month component in the localized value of $a.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnYearFromDateTime = new FunctionSignature(new QName("year-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer representing the year in the localized value of $a. The value may be negative.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnHoursFromDateTime = new FunctionSignature(new QName("hours-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer between 0 and 23, both inclusive, representing the value of the hours component in the localized value of $arg.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnMinutesFromDateTime = new FunctionSignature(new QName("minutes-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer value between 0 to 59, both inclusive, representing the value of the minutes component in the localized value of $arg.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(31, 3));
    public static final FunctionSignature fnSecondsFromDateTime = new FunctionSignature(new QName("seconds-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:decimal value between 0 and 60.999..., both inclusive, representing the seconds and fractional seconds in the localized value of $arg. Note that the value can be greater than 60 seconds to accommodate occasional leap seconds used to keep human time synchronized with the rotation of the planet.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(32, 3));
    public static final FunctionSignature fnTimezoneFromDateTime = new FunctionSignature(new QName("timezone-from-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns the timezone component of $arg if any. If $arg has a timezone component, then the result is an xdt:dayTimeDuration that indicates deviation from UTC; its value may range from +14:00 to -14:00 hours, both inclusive. Otherwise, the result is the empty sequence.", new SequenceType[]{new SequenceType(50, 3)}, new SequenceType(55, 3));

    public FunGetDateComponent(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args.length == 0 || args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Sequence arg = args[0];
            AbstractDateTimeValue date = (AbstractDateTimeValue)arg.itemAt(0);
            if (this.isCalledAs("day-from-dateTime") || this.isCalledAs("day-from-date")) {
                result = new IntegerValue(date.getPart(2), 31);
            } else if (this.isCalledAs("month-from-dateTime") || this.isCalledAs("month-from-date")) {
                result = new IntegerValue(date.getPart(1), 31);
            } else if (this.isCalledAs("year-from-dateTime") || this.isCalledAs("year-from-date")) {
                result = new IntegerValue(date.getPart(0), 31);
            } else if (this.isCalledAs("hours-from-dateTime") || this.isCalledAs("hours-from-time")) {
                result = new IntegerValue(date.getPart(3), 31);
            } else if (this.isCalledAs("minutes-from-dateTime") || this.isCalledAs("minutes-from-time")) {
                result = new IntegerValue(date.getPart(4), 31);
            } else if (this.isCalledAs("seconds-from-dateTime") || this.isCalledAs("seconds-from-time")) {
                result = new IntegerValue(date.calendar.getSecond()).convertTo(32);
                if (date.calendar.getFractionalSecond() != null) {
                    result = ((DecimalValue)result).plus(new DecimalValue(date.calendar.getFractionalSecond()));
                }
            } else if (this.isCalledAs("timezone-from-dateTime") || this.isCalledAs("timezone-from-date") || this.isCalledAs("timezone-from-time")) {
                result = date.getTimezone();
            } else {
                throw new Error("can't handle function " + this.mySignature.getName().getLocalName());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public int getDependencies() {
        return 0;
    }
}

