/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.DocUtils;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDocAvailable
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("doc-available", "http://www.w3.org/2005/xpath-functions"), "Returns whether or not the document specified in the input sequence is available. The arguments are either document pathes like '/db/shakespeare/plays/hamlet.xml' or XMLDB URIs like 'xmldb:exist://localhost:8081//db/shakespeare/plays/hamlet.xml' or standard URLs, starting with http://, file://, etc.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(23, 2));

    public FunDocAvailable(XQueryContext context) {
        super(context, signature);
    }

    public int getDependencies() {
        return 1;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        Sequence arg;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((arg = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = BooleanValue.FALSE;
        } else {
            String path = arg.itemAt(0).getStringValue();
            try {
                result = BooleanValue.valueOf(DocUtils.isDocumentAvailable(this.context, path));
            }
            catch (Exception e) {
                throw new XPathException(this.getASTNode(), e.getMessage());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.getArgument(0).resetState(postOptimization);
    }
}

