/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class ConditionalExpression
extends AbstractExpression {
    private final Expression testExpr;
    private final Expression thenExpr;
    private final Expression elseExpr;

    public ConditionalExpression(XQueryContext context, Expression testExpr, Expression thenExpr, Expression elseExpr) {
        super(context);
        this.testExpr = testExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public int getDependencies() {
        return 3;
    }

    public Expression getTestExpr() {
        return this.testExpr;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public int getCardinality() {
        return this.thenExpr.getCardinality() | this.elseExpr.getCardinality();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setFlags(contextInfo.getFlags() & 0xFFFFFFFD);
        contextInfo.setParent(this);
        this.testExpr.analyze(contextInfo);
        this.thenExpr.analyze(contextInfo);
        this.elseExpr.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence testSeq = this.testExpr.eval(contextSequence, contextItem);
        try {
            if (testSeq.effectiveBooleanValue()) {
                return this.thenExpr.eval(contextSequence, contextItem);
            }
            return this.elseExpr.eval(contextSequence, contextItem);
        }
        catch (XPathException e) {
            if (e.getLine() == 0) {
                e.setASTNode(this.getASTNode());
            }
            throw e;
        }
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("if (");
        dumper.startIndent();
        this.testExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display(") then");
        dumper.startIndent();
        this.thenExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("else");
        dumper.startIndent();
        this.elseExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("if ( ");
        result.append(this.testExpr.toString());
        result.append(" ) then ");
        result.append(this.thenExpr.toString());
        result.append(" else ");
        result.append(this.elseExpr.toString());
        return result.toString();
    }

    public int returnsType() {
        return Type.getCommonSuperType(this.thenExpr.returnsType(), this.elseExpr.returnsType());
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.testExpr.resetState(postOptimization);
        this.thenExpr.resetState(postOptimization);
        this.elseExpr.resetState(postOptimization);
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitConditional(this);
    }
}

