/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class CDATAConstructor
extends NodeConstructor {
    private final String cdata;

    public CDATAConstructor(XQueryContext context, String content) {
        super(context);
        this.cdata = content;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        int nodeNr = builder.cdataSection(this.cdata);
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", node);
        }
        return node;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("<![CDATA[").display(this.cdata).display("]]>");
    }

    public String toString() {
        return "<![CDATA[" + this.cdata.toString() + "]]>";
    }
}

