/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceSet
implements ResourceSet {
    protected RemoteCollection collection;
    protected int handle = -1;
    protected Vector resources;
    protected Properties outputProperties;
    private static Logger LOG = Logger.getLogger((String)RemoteResourceSet.class.getName());

    public RemoteResourceSet(RemoteCollection col, Properties properties, Vector resources, int handle) {
        this.handle = handle;
        this.resources = resources;
        this.collection = col;
        this.outputProperties = properties;
    }

    public void addResource(Resource resource) {
        this.resources.addElement(resource);
    }

    public void clear() throws XMLDBException {
        Vector<Integer> params = new Vector<Integer>();
        params.addElement(new Integer(this.handle));
        try {
            this.collection.getClient().execute("releaseQueryResult", params);
        }
        catch (XmlRpcException e) {
            System.err.println("Failed to release query result on server: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Failed to release query result on server: " + e.getMessage());
        }
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        Vector<Serializable> params = new Vector<Serializable>();
        params.addElement(new Integer(this.handle));
        params.addElement(this.outputProperties);
        try {
            String content;
            byte[] data = (byte[])this.collection.getClient().execute("retrieveAll", params);
            try {
                content = new String(data, this.outputProperties.getProperty("encoding", "UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                LOG.warn((Object)ue);
                content = new String(data);
            }
            RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, 0, XmldbURI.EMPTY_URI, null);
            res.setContent(content);
            res.setProperties(this.outputProperties);
            return res;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos >= (long)this.resources.size()) {
            return null;
        }
        if (this.resources.elementAt((int)pos) instanceof Vector) {
            XmldbURI docUri;
            Vector v = (Vector)this.resources.elementAt((int)pos);
            String doc = (String)v.elementAt(0);
            String s_id = (String)v.elementAt(1);
            try {
                docUri = XmldbURI.xmldbUriFor(doc);
            }
            catch (URISyntaxException e) {
                throw new XMLDBException(5, e.getMessage(), (Throwable)e);
            }
            RemoteCollection parent = new RemoteCollection(this.collection.getClient(), null, docUri.removeLastSegment());
            parent.properties = this.outputProperties;
            RemoteXMLResource res = new RemoteXMLResource(parent, this.handle, (int)pos, docUri, s_id);
            res.setProperties(this.outputProperties);
            return res;
        }
        if (this.resources.elementAt((int)pos) instanceof Resource) {
            return (Resource)this.resources.elementAt((int)pos);
        }
        RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, (int)pos, XmldbURI.create(Long.toString(pos)), null);
        res.setContent(this.resources.elementAt((int)pos));
        res.setProperties(this.outputProperties);
        return res;
    }

    public long getSize() throws XMLDBException {
        return this.resources == null ? 0L : (long)this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.removeElementAt((int)pos);
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return RemoteResourceSet.this.resources == null ? false : this.pos < (long)RemoteResourceSet.this.resources.size();
        }

        public Resource nextResource() throws XMLDBException {
            return RemoteResourceSet.this.getResource(this.pos++);
        }
    }
}

