/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.XMLString;
import org.exist.util.serializer.XMLWriter;
import org.exist.util.serializer.encodings.CharacterSet;

public class TEXTWriter
extends XMLWriter {
    protected static final Properties defaultProperties = new Properties();
    protected Writer writer = null;
    protected CharacterSet charSet = null;
    protected Properties outputProperties;
    private char[] charref = new char[10];

    public TEXTWriter() {
    }

    public TEXTWriter(Writer writer) {
        this.writer = writer;
    }

    protected void reset() {
        super.reset();
        this.writer = null;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = properties == null ? defaultProperties : properties;
        String encoding = this.outputProperties.getProperty("encoding", "UTF-8");
        this.charSet = CharacterSet.getCharacterSet(encoding);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument() throws TransformerException {
    }

    public void endDocument() throws TransformerException {
    }

    public void startElement(String qname) throws TransformerException {
    }

    public void startElement(QName qname) throws TransformerException {
    }

    public void endElement(String qname) throws TransformerException {
    }

    public void endElement(QName qname) throws TransformerException {
    }

    public void namespace(String prefix, String nsURI) throws TransformerException {
    }

    public void attribute(String qname, String value) throws TransformerException {
    }

    public void attribute(QName qname, String value) throws TransformerException {
    }

    public void characters(CharSequence chars) throws TransformerException {
        try {
            this.writeChars(chars, false);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void characters(char[] ch, int start, int len) throws TransformerException {
        XMLString s = new XMLString(ch, start, len);
        this.characters(s);
        s.release();
    }

    public void processingInstruction(String target, String data) throws TransformerException {
    }

    public void comment(CharSequence data) throws TransformerException {
    }

    public void cdataSection(char[] ch, int start, int len) throws TransformerException {
        try {
            this.writer.write(ch, start, len);
        }
        catch (IOException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public void documentType(String name, String publicId, String systemId) throws TransformerException {
    }

    protected void closeStartTag(boolean isEmpty) throws TransformerException {
    }

    protected void writeDeclaration() throws TransformerException {
    }

    protected void writeDoctype(String rootElement) throws TransformerException {
    }

    private final void writeChars(CharSequence s, boolean inAttribute) throws IOException {
        int len = s.length();
        this.writeCharSeq(s, 0, len);
    }

    private void writeCharSeq(CharSequence ch, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.writer.write(ch.charAt(i));
        }
    }

    protected void writeCharacterReference(char charval) throws IOException {
        int o = 0;
        this.charref[o++] = 38;
        this.charref[o++] = 35;
        this.charref[o++] = 120;
        String code = Integer.toHexString(charval);
        int len = code.length();
        for (int k = 0; k < len; ++k) {
            this.charref[o++] = code.charAt(k);
        }
        this.charref[o++] = 59;
        this.writer.write(this.charref, 0, o);
    }
}

