/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class SequencedLongHashMap
extends AbstractHashtable {
    protected long[] keys = new long[this.tabSize];
    protected Entry[] values = new Entry[this.tabSize];
    private Entry first = null;
    private Entry last = null;

    public SequencedLongHashMap() {
    }

    public SequencedLongHashMap(int iSize) {
        super(iSize);
    }

    public void put(long key, Object value) {
        Entry entry = this.insert(key, value);
        if (this.first == null) {
            this.last = this.first = entry;
        } else {
            this.last.next = entry;
            entry.prev = this.last;
            this.last = entry;
        }
    }

    protected Entry insert(long key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = new Entry(key, value);
            ++this.items;
            return this.values[idx];
        }
        Entry next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                next.value = value;
                this.removeEntry(next);
                return next;
            }
            next = next.nextDup;
        }
        next = new Entry(key, value);
        next.nextDup = this.values[idx];
        this.values[idx].prevDup = next;
        this.values[idx] = next;
        ++this.items;
        return next;
    }

    public Object get(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        Entry next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                return next.value;
            }
            next = next.nextDup;
        }
        return null;
    }

    public Entry getFirstEntry() {
        return this.first;
    }

    public Object remove(long key) {
        Entry entry = this.removeFromHashtable(key);
        if (entry != null) {
            this.removeEntry(entry);
            return entry.value;
        }
        return null;
    }

    private Entry removeFromHashtable(long key) {
        int idx = SequencedLongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return null;
        }
        Entry next = this.values[idx];
        while (next != null) {
            if (next.key == key) {
                if (next.prevDup == null) {
                    this.values[idx] = next.nextDup;
                    if (this.values[idx] != null) {
                        this.values[idx].prevDup = null;
                    }
                } else {
                    next.prevDup.nextDup = next.nextDup;
                    if (next.nextDup != null) {
                        next.nextDup.prevDup = next.prevDup;
                    }
                }
                --this.items;
                return next;
            }
            next = next.nextDup;
        }
        return null;
    }

    public Object removeFirst() {
        if (this.first == null) {
            return null;
        }
        Entry head = this.first;
        this.removeFromHashtable(this.first.key);
        this.removeEntry(this.first);
        return head;
    }

    public void removeEntry(Entry entry) {
        if (entry.prev == null) {
            if (entry.next == null) {
                this.first = null;
                this.last = null;
            } else {
                entry.next.prev = null;
                this.first = entry.next;
            }
        } else {
            entry.prev.next = entry.next;
            if (entry.next == null) {
                this.last = entry.prev;
            } else {
                entry.next.prev = entry.prev;
            }
        }
        entry.prev = null;
        entry.next = null;
    }

    public void clear() {
        for (int i = 0; i < this.tabSize; ++i) {
            this.values[i] = null;
        }
        this.items = 0;
        this.first = null;
        this.last = null;
    }

    protected static final int hash(long l) {
        return (int)(l ^ l >>> 32);
    }

    public Iterator iterator() {
        return new SequencedLongIterator(0);
    }

    public Iterator valueIterator() {
        return new SequencedLongIterator(1);
    }

    protected class SequencedLongIterator
    extends AbstractHashtable.HashtableIterator {
        private Entry current;

        public SequencedLongIterator(int type) {
            super(type);
            this.current = SequencedLongHashMap.this.first;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                return null;
            }
            Entry next = this.current;
            this.current = this.current.next;
            if (this.returnType == 1) {
                return next.value;
            }
            return new Long(next.key);
        }
    }

    public static final class Entry {
        long key;
        Object value;
        Entry next = null;
        Entry prev = null;
        Entry prevDup = null;
        Entry nextDup = null;

        public Entry(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Entry getNext() {
            return this.next;
        }

        public long getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.key);
        }
    }
}

