/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.ItemId;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdateValueLoggable
extends AbstractLoggable {
    protected DOMFile domDb;
    protected long pageNum;
    protected short tid;
    protected byte[] value;
    protected byte[] oldValue;
    protected int oldOffset;

    public UpdateValueLoggable(Txn transaction, long pageNum, short tid, byte[] value, byte[] oldValue, int oldOffset) {
        super((byte)20, transaction.getId());
        this.pageNum = pageNum;
        this.tid = tid;
        this.value = value;
        this.oldValue = oldValue;
        this.oldOffset = oldOffset;
    }

    public UpdateValueLoggable(DBBroker broker, long transactionId) {
        super((byte)20, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putShort(this.tid);
        out.putShort((short)this.value.length);
        out.put(this.value);
        out.putShort((short)this.oldOffset);
        out.put(this.oldValue, this.oldOffset, this.value.length);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.tid = in.getShort();
        this.value = new byte[in.getShort()];
        in.get(this.value);
        this.oldOffset = in.getShort();
        this.oldValue = new byte[this.value.length];
        in.get(this.oldValue);
    }

    public int getLogSize() {
        return 10 + this.value.length * 2;
    }

    public void redo() throws LogException {
        this.domDb.redoUpdateValue(this);
    }

    public void undo() throws LogException {
        this.domDb.undoUpdateValue(this);
    }

    public String dump() {
        return super.dump() + " - updated value; tid = " + ItemId.getId(this.tid) + " to page " + this.pageNum;
    }
}

