/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.Backup;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;
import org.xmldb.api.base.XMLDBException;

public class BackupSystemTask
implements SystemTask {
    private static final Logger LOG = Logger.getLogger((Class)BackupSystemTask.class);
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
    private String user;
    private String password;
    private File directory;
    private String suffix;
    private XmldbURI collection;
    private String prefix;
    private int zipFilesMax = -1;

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.user = properties.getProperty("user", "guest");
        this.password = properties.getProperty("password", "guest");
        String collName = properties.getProperty("collection", "xmldb:exist:///db");
        if (!collName.startsWith("xmldb:exist:")) {
            collName = "xmldb:exist://" + collName;
        }
        this.collection = XmldbURI.create(collName);
        LOG.debug((Object)("Collection to backup: " + this.collection.toString() + ". User: " + this.user));
        this.suffix = properties.getProperty("suffix", "");
        this.prefix = properties.getProperty("prefix", "");
        String dir = properties.getProperty("dir", "backup");
        this.directory = new File(dir);
        if (!this.directory.isAbsolute()) {
            dir = (String)config.getProperty("db-connection.data-dir") + File.separatorChar + dir;
            this.directory = new File(dir);
        }
        this.directory.mkdirs();
        String filesMaxStr = properties.getProperty("zip-files-max");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zip-files-max: " + filesMaxStr));
        }
        if (null != filesMaxStr) {
            try {
                this.zipFilesMax = new Integer(filesMaxStr);
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)"zip-files-max property error", (Throwable)e);
            }
        }
    }

    public void execute(DBBroker broker) throws EXistException {
        String dateTime = df.format(new Date());
        String dest = this.directory.getAbsolutePath() + File.separatorChar + this.prefix + dateTime + this.suffix;
        Backup backup = new Backup(this.user, this.password, dest, this.collection);
        try {
            backup.backup(false, null);
        }
        catch (XMLDBException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new EXistException(e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new EXistException(e.getMessage(), e);
        }
        catch (SAXException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new EXistException(e.getMessage(), e);
        }
        if (this.suffix.equals(".zip") && this.zipFilesMax > 0) {
            this.purgeZipFiles();
        }
    }

    public void purgeZipFiles() {
        File[] files;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"starting purgeZipFiles()");
        }
        if ((files = this.directory.listFiles()).length > 0) {
            TreeMap<String, File> sorted = new TreeMap<String, File>();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().startsWith(this.prefix) || !files[i].getName().endsWith(this.suffix)) continue;
                sorted.put(Long.toString(files[i].lastModified()), files[i]);
            }
            if (sorted.size() > this.zipFilesMax) {
                Set keys = sorted.keySet();
                Iterator ki = keys.iterator();
                int i = sorted.size() - this.zipFilesMax;
                while (ki.hasNext()) {
                    File f = (File)sorted.get(ki.next());
                    if (i > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Purging backup : " + f.getName()));
                        }
                        f.delete();
                    }
                    --i;
                }
            }
        }
    }
}

