/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Properties;
import java.util.Vector;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLLexer;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.UnknownPositionException;
import org.z3950.zing.cql.UnknownQualifierException;
import org.z3950.zing.cql.UnknownRelationException;
import org.z3950.zing.cql.UnknownRelationModifierException;

public class CQLParser {
    private static boolean DEBUG = false;
    private static boolean LEXDEBUG = false;
    private CQLLexer lexer;

    private static final void debug(String string) {
        if (DEBUG) {
            System.err.println("PARSEDEBUG: " + string);
        }
    }

    public CQLNode parse(String string) throws CQLParseException, IOException {
        this.lexer = new CQLLexer(string, LEXDEBUG);
        this.lexer.nextToken();
        CQLParser.debug("about to parseQuery()");
        CQLNode cQLNode = this.parseQuery("srw.serverChoice", new CQLRelation("scr"));
        if (this.lexer.ttype != StreamTokenizer.TT_EOF) {
            throw new CQLParseException("junk after end: " + this.lexer.render());
        }
        return cQLNode;
    }

    private final CQLNode parseQuery(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLParser.debug("in parseQuery()");
        CQLNode cQLNode = this.parseTerm(string, cQLRelation);
        while (this.lexer.ttype != StreamTokenizer.TT_EOF && this.lexer.ttype != 41) {
            CQLNode cQLNode2;
            if (this.lexer.ttype == CQLLexer.TT_AND) {
                this.match(CQLLexer.TT_AND);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLAndNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype == CQLLexer.TT_OR) {
                this.match(CQLLexer.TT_OR);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLOrNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype == CQLLexer.TT_NOT) {
                this.match(CQLLexer.TT_NOT);
                cQLNode2 = this.parseTerm(string, cQLRelation);
                cQLNode = new CQLNotNode(cQLNode, cQLNode2);
                continue;
            }
            if (this.lexer.ttype == CQLLexer.TT_PROX) {
                this.match(CQLLexer.TT_PROX);
                cQLNode2 = new CQLProxNode(cQLNode);
                this.gatherProxParameters((CQLProxNode)cQLNode2);
                CQLNode cQLNode3 = this.parseTerm(string, cQLRelation);
                ((CQLProxNode)cQLNode2).addSecondSubterm(cQLNode3);
                cQLNode = cQLNode2;
                continue;
            }
            throw new CQLParseException("expected boolean, got " + this.lexer.render());
        }
        CQLParser.debug("no more ops");
        return cQLNode;
    }

    private final CQLNode parseTerm(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        String string2;
        CQLParser.debug("in parseTerm()");
        while (true) {
            if (this.lexer.ttype == 40) {
                CQLParser.debug("parenthesised term");
                this.match(40);
                CQLNode cQLNode = this.parseQuery(string, cQLRelation);
                this.match(41);
                return cQLNode;
            }
            if (this.lexer.ttype == 62) {
                this.match(62);
                return this.parsePrefix(string, cQLRelation);
            }
            CQLParser.debug("non-parenthesised term");
            string2 = this.matchSymbol("qualifier or term");
            if (!this.isBaseRelation()) break;
            string = string2;
            cQLRelation = new CQLRelation(this.lexer.ttype == StreamTokenizer.TT_WORD ? this.lexer.sval : this.lexer.render(this.lexer.ttype, false));
            this.match(this.lexer.ttype);
            while (this.lexer.ttype == 47) {
                this.match(47);
                if (this.lexer.ttype != CQLLexer.TT_RELEVANT && this.lexer.ttype != CQLLexer.TT_FUZZY && this.lexer.ttype != CQLLexer.TT_STEM && this.lexer.ttype != CQLLexer.TT_PHONETIC && this.lexer.ttype != StreamTokenizer.TT_WORD) {
                    throw new CQLParseException("expected relation modifier, got " + this.lexer.render());
                }
                if (this.lexer.ttype == StreamTokenizer.TT_WORD && this.lexer.sval.indexOf(46) == -1) {
                    throw new CQLParseException("unknown first-class relation modifier: " + this.lexer.sval);
                }
                cQLRelation.addModifier(this.lexer.sval.toLowerCase());
                this.match(this.lexer.ttype);
            }
            CQLParser.debug("qualifier='" + string + ", " + "relation='" + cQLRelation.toCQL() + "'");
        }
        CQLTermNode cQLTermNode = new CQLTermNode(string, cQLRelation, string2);
        CQLParser.debug("made term node " + cQLTermNode.toCQL());
        return cQLTermNode;
    }

    private final CQLNode parsePrefix(String string, CQLRelation cQLRelation) throws CQLParseException, IOException {
        CQLParser.debug("prefix mapping");
        String string2 = null;
        String string3 = this.matchSymbol("prefix-name");
        if (this.lexer.ttype == 61) {
            this.match(61);
            string2 = string3;
            string3 = this.matchSymbol("prefix-identifer");
        }
        CQLNode cQLNode = this.parseQuery(string, cQLRelation);
        return new CQLPrefixNode(string2, string3, cQLNode);
    }

    private final void gatherProxParameters(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        int n = 0;
        while (n < 4) {
            if (this.lexer.ttype != 47) {
                return;
            }
            this.match(47);
            if (this.lexer.ttype != 47) {
                switch (n) {
                    case 0: {
                        this.gatherProxRelation(cQLProxNode);
                        break;
                    }
                    case 1: {
                        this.gatherProxDistance(cQLProxNode);
                        break;
                    }
                    case 2: {
                        this.gatherProxUnit(cQLProxNode);
                        break;
                    }
                    case 3: {
                        this.gatherProxOrdering(cQLProxNode);
                        break;
                    }
                }
            }
            ++n;
        }
    }

    private final void gatherProxRelation(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (!this.isProxRelation()) {
            throw new CQLParseException("expected proximity relation, got " + this.lexer.render());
        }
        cQLProxNode.addModifier("relation", this.lexer.render(this.lexer.ttype, false));
        this.match(this.lexer.ttype);
        CQLParser.debug("gPR matched " + this.lexer.render(this.lexer.ttype, false));
    }

    private final void gatherProxDistance(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (this.lexer.ttype != StreamTokenizer.TT_NUMBER) {
            throw new CQLParseException("expected proximity distance, got " + this.lexer.render());
        }
        cQLProxNode.addModifier("distance", this.lexer.render(this.lexer.ttype, false));
        this.match(this.lexer.ttype);
        CQLParser.debug("gPD matched " + this.lexer.render(this.lexer.ttype, false));
    }

    private final void gatherProxUnit(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (this.lexer.ttype != CQLLexer.TT_pWORD && this.lexer.ttype != CQLLexer.TT_SENTENCE && this.lexer.ttype != CQLLexer.TT_PARAGRAPH && this.lexer.ttype != CQLLexer.TT_ELEMENT) {
            throw new CQLParseException("expected proximity unit, got " + this.lexer.render());
        }
        cQLProxNode.addModifier("unit", this.lexer.render());
        this.match(this.lexer.ttype);
    }

    private final void gatherProxOrdering(CQLProxNode cQLProxNode) throws CQLParseException, IOException {
        if (this.lexer.ttype != CQLLexer.TT_ORDERED && this.lexer.ttype != CQLLexer.TT_UNORDERED) {
            throw new CQLParseException("expected proximity ordering, got " + this.lexer.render());
        }
        cQLProxNode.addModifier("ordering", this.lexer.render());
        this.match(this.lexer.ttype);
    }

    private final boolean isBaseRelation() throws CQLParseException {
        CQLParser.debug("isBaseRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        if (this.lexer.ttype == StreamTokenizer.TT_WORD && this.lexer.sval.indexOf(46) == -1) {
            throw new CQLParseException("unknown first-class relation: " + this.lexer.sval);
        }
        return this.isProxRelation() || this.lexer.ttype == CQLLexer.TT_ANY || this.lexer.ttype == CQLLexer.TT_ALL || this.lexer.ttype == CQLLexer.TT_EXACT || this.lexer.ttype == CQLLexer.TT_SCR || this.lexer.ttype == StreamTokenizer.TT_WORD;
    }

    private final boolean isProxRelation() {
        CQLParser.debug("isProxRelation: checking ttype=" + this.lexer.ttype + " (" + this.lexer.render() + ")");
        return this.lexer.ttype == 60 || this.lexer.ttype == 62 || this.lexer.ttype == 61 || this.lexer.ttype == CQLLexer.TT_LE || this.lexer.ttype == CQLLexer.TT_GE || this.lexer.ttype == CQLLexer.TT_NE;
    }

    private final void match(int n) throws CQLParseException, IOException {
        CQLParser.debug("in match(" + this.lexer.render(n, true) + ")");
        if (this.lexer.ttype != n) {
            throw new CQLParseException("expected " + this.lexer.render(n, true) + ", " + "got " + this.lexer.render());
        }
        int n2 = this.lexer.nextToken();
        CQLParser.debug("match() got token=" + this.lexer.ttype + ", " + "nval=" + this.lexer.nval + ", sval='" + this.lexer.sval + "'" + " (tmp=" + n2 + ")");
    }

    private final String matchSymbol(String string) throws CQLParseException, IOException {
        CQLParser.debug("in matchSymbol()");
        if (this.lexer.ttype == StreamTokenizer.TT_WORD || this.lexer.ttype == StreamTokenizer.TT_NUMBER || this.lexer.ttype == 34 || this.lexer.ttype == CQLLexer.TT_AND || this.lexer.ttype == CQLLexer.TT_OR || this.lexer.ttype == CQLLexer.TT_NOT || this.lexer.ttype == CQLLexer.TT_PROX || this.lexer.ttype == CQLLexer.TT_ANY || this.lexer.ttype == CQLLexer.TT_ALL || this.lexer.ttype == CQLLexer.TT_EXACT || this.lexer.ttype == CQLLexer.TT_pWORD || this.lexer.ttype == CQLLexer.TT_SENTENCE || this.lexer.ttype == CQLLexer.TT_PARAGRAPH || this.lexer.ttype == CQLLexer.TT_ELEMENT || this.lexer.ttype == CQLLexer.TT_ORDERED || this.lexer.ttype == CQLLexer.TT_UNORDERED || this.lexer.ttype == CQLLexer.TT_RELEVANT || this.lexer.ttype == CQLLexer.TT_FUZZY || this.lexer.ttype == CQLLexer.TT_STEM || this.lexer.ttype == CQLLexer.TT_SCR || this.lexer.ttype == CQLLexer.TT_PHONETIC) {
            String string2 = this.lexer.ttype == StreamTokenizer.TT_NUMBER ? this.lexer.render() : this.lexer.sval;
            this.match(this.lexer.ttype);
            return string2;
        }
        throw new CQLParseException("expected " + string + ", " + "got " + this.lexer.render());
    }

    public static void main(String[] stringArray) {
        Object object;
        String string;
        int n = 120;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.add(stringArray[n2]);
            ++n2;
        }
        if (vector.size() > 0 && vector.get(0).equals("-c")) {
            n = 99;
            vector.remove(0);
        } else if (vector.size() > 1 && vector.get(0).equals("-p")) {
            n = 112;
            vector.remove(0);
            string2 = (String)vector.get(0);
            vector.remove(0);
        }
        if (vector.size() > 1) {
            System.err.println("Usage: CQLParser [-c] [-p <pqf-properties> [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (vector.size() == 1) {
            string = (String)vector.get(0);
        } else {
            object = new byte[10000];
            try {
                int n3 = System.in.read((byte[])object);
            }
            catch (IOException iOException) {
                System.err.println("Can't read query: " + iOException.getMessage());
                System.exit(2);
            }
            string = new String((byte[])object);
        }
        object = new CQLParser();
        CQLNode cQLNode = null;
        try {
            cQLNode = ((CQLParser)object).parse(string);
        }
        catch (CQLParseException cQLParseException) {
            System.err.println("Syntax error: " + cQLParseException.getMessage());
            System.exit(3);
        }
        catch (IOException iOException) {
            System.err.println("Can't compile query: " + iOException.getMessage());
            System.exit(4);
        }
        try {
            if (n == 99) {
                System.out.println(cQLNode.toCQL());
            } else if (n == 112) {
                FileInputStream fileInputStream = new FileInputStream(string2);
                if (fileInputStream == null) {
                    throw new FileNotFoundException(string2);
                }
                Properties properties = new Properties();
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                System.out.println(cQLNode.toPQF(properties));
            } else {
                System.out.print(cQLNode.toXCQL(0));
            }
        }
        catch (IOException iOException) {
            System.err.println("Can't render query: " + iOException.getMessage());
            System.exit(5);
        }
        catch (UnknownQualifierException unknownQualifierException) {
            System.err.println("Unknown qualifier: " + unknownQualifierException.getMessage());
            System.exit(6);
        }
        catch (UnknownRelationException unknownRelationException) {
            System.err.println("Unknown relation: " + unknownRelationException.getMessage());
            System.exit(7);
        }
        catch (UnknownRelationModifierException unknownRelationModifierException) {
            System.err.println("Unknown relation modifier: " + unknownRelationModifierException.getMessage());
            System.exit(8);
        }
        catch (UnknownPositionException unknownPositionException) {
            System.err.println("Unknown position: " + unknownPositionException.getMessage());
            System.exit(9);
        }
        catch (PQFTranslationException pQFTranslationException) {
            throw new Error("can't get a PQFTranslationException");
        }
    }
}

