/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.z3950.zing.cql.CQLPrefix;
import org.z3950.zing.cql.PQFTranslationException;
import org.z3950.zing.cql.Utils;

public abstract class CQLNode {
    protected static final int UNIVERSAL = 0;
    protected static final int APPLICATION = 1;
    protected static final int CONTEXT = 2;
    protected static final int PRIVATE = 3;
    protected static final int PRIMITIVE = 0;
    protected static final int CONSTRUCTED = 1;
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BITSTRING = 3;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte OBJECTIDENTIFIER = 6;
    public static final byte OBJECTDESCRIPTOR = 7;
    public static final byte EXTERNAL = 8;
    public static final byte ENUMERATED = 10;
    public static final byte SEQUENCE = 16;
    public static final byte SET = 17;
    public static final byte VISIBLESTRING = 26;
    public static final byte GENERALSTRING = 27;
    private static final Hashtable madeOIDs = new Hashtable(10);

    public String getResultSetName() {
        return null;
    }

    public String toXCQL(int n) {
        return this.toXCQL(n, new Vector());
    }

    public abstract String toXCQL(int var1, Vector var2);

    protected static String renderPrefixes(int n, Vector vector) {
        if (vector.size() == 0) {
            return "";
        }
        String string = CQLNode.indent(n) + "<prefixes>\n";
        int n2 = 0;
        while (n2 < vector.size()) {
            CQLPrefix cQLPrefix = (CQLPrefix)vector.get(n2);
            string = string + CQLNode.indent(n + 1) + "<prefix>\n";
            if (cQLPrefix.name != null) {
                string = string + CQLNode.indent(n + 2) + "<name>" + cQLPrefix.name + "</name>\n";
            }
            string = string + CQLNode.indent(n + 2) + "<identifier>" + cQLPrefix.identifier + "</identifier>\n";
            string = string + CQLNode.indent(n + 1) + "</prefix>\n";
            ++n2;
        }
        return string + CQLNode.indent(n) + "</prefixes>\n";
    }

    public abstract String toCQL();

    public abstract String toPQF(Properties var1) throws PQFTranslationException;

    protected static String indent(int n) {
        return Utils.indent(n);
    }

    protected static String xq(String string) {
        return Utils.xq(string);
    }

    public abstract byte[] toType1BER(Properties var1) throws PQFTranslationException;

    protected static final int putTag(int n, int n2, int n3, byte[] byArray, int n4) {
        if (n2 < 31) {
            byArray[n4++] = (byte)(n2 + n * 64 + n3 * 32);
        } else {
            byArray[n4++] = (byte)(31 + n * 64 + n3 * 32);
            if (n2 < 128) {
                byArray[n4++] = (byte)n2;
            } else {
                byArray[n4++] = (byte)(128 + n2 / 128);
                byArray[n4++] = (byte)(n2 % 128);
            }
        }
        return n4;
    }

    public static final int putLen(int n, byte[] byArray, int n2) {
        if (n < 128) {
            byArray[n2++] = (byte)n;
        } else {
            byArray[n2] = (byte)(CQLNode.lenLen(n) - 1);
            int n3 = byArray[n2];
            while (n3 > 0) {
                byArray[n2 + n3] = (byte)(n & 0xFF);
                n >>= 8;
                --n3;
            }
            n3 = n2;
            n2 += (byArray[n2] & 0xFF) + 1;
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] + 128);
        }
        return n2;
    }

    protected static final int lenLen(int n) {
        return n < 128 ? 1 : (n < 256 ? 2 : ((long)n < 65536L ? 3 : 4));
    }

    protected static final int numLen(long l) {
        long l2 = l = l < 0L ? -l : l;
        return l < 128L ? 1 : (l < 32768L ? 2 : (l < 0x800000L ? 3 : (l < 0x80000000L ? 4 : (l < 0x8000000000L ? 5 : (l < 0x800000000000L ? 6 : (l < 0x80000000000000L ? 7 : 8))))));
    }

    protected static final int putNum(long l, byte[] byArray, int n) {
        int n2 = CQLNode.numLen(l);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            byArray[n + n3] = (byte)(l & 0xFFL);
            l >>= 8;
            --n3;
        }
        return n + n2;
    }

    protected static final byte[] makeOID(String string) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = (byte[])madeOIDs.get(string);
        if (byArray == null) {
            byArray = new byte[100];
            while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
                if (n > 90) {
                    return null;
                }
                int n3 = string.indexOf(46, n2);
                if (n3 == -1) {
                    n3 = string.length();
                }
                int n4 = Integer.parseInt(string.substring(n2, n3));
                if (n == 0) {
                    if (n3 == -1) {
                        return null;
                    }
                    n2 = n3 + 1;
                    if ((n3 = string.indexOf(46, n2)) == -1) {
                        n3 = string.length();
                    }
                    n4 = n4 * 40 + Integer.parseInt(string.substring(n2, n3));
                }
                if (n4 < 128) {
                    byArray[n++] = (byte)n4;
                } else {
                    int n5 = 0;
                    byte[] byArray2 = new byte[12];
                    while (n4 != 0) {
                        byArray2[n5++] = (byte)(n4 & 0x7F);
                        n4 >>= 7;
                    }
                    while (--n5 > 0) {
                        byArray[n++] = (byte)(byArray2[n5] | 0x80);
                    }
                    byArray[n++] = byArray2[n5];
                }
                n3 = string.indexOf(46, n2);
                if (n3 == -1) break;
                n2 = n3 + 1;
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            madeOIDs.put(string, byArray3);
            return byArray3;
        }
        return byArray;
    }

    public static final byte[] makeQuery(CQLNode cQLNode, Properties properties) throws PQFTranslationException {
        byte[] byArray = cQLNode.toType1BER(properties);
        byte[] byArray2 = new byte[byArray.length + 100];
        int n = 0;
        n = CQLNode.putTag(2, 1, 1, byArray2, n);
        byArray2[n++] = -128;
        n = CQLNode.putTag(0, 6, 0, byArray2, n);
        byte[] byArray3 = CQLNode.makeOID("1.2.840.10003.3.1");
        n = CQLNode.putLen(byArray3.length, byArray2, n);
        System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, n += byArray3.length, byArray.length);
        n += byArray.length;
        byArray2[n++] = 0;
        byArray2[n++] = 0;
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray2, 0, byArray4, 0, n);
        return byArray4;
    }

    CQLNode() {
    }
}

