/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ReverseCodeTableHandler
extends DefaultHandler {
    private Hashtable charset;
    private Vector combiningchars;
    private Integer isocode;
    private char[] marc;
    private Character ucs;
    private boolean combining;
    private String tag;
    private StringBuffer data;
    private Locator locator;

    public Hashtable getCharSets() {
        return this.charset;
    }

    public Vector getCombiningChars() {
        return this.combiningchars;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
        if (string2.equals("characterSet")) {
            this.isocode = Integer.valueOf(attributes.getValue("ISOcode"), 16);
        } else if (string2.equals("marc")) {
            this.data = new StringBuffer();
        } else if (string2.equals("codeTables")) {
            this.charset = new Hashtable();
            this.combiningchars = new Vector();
        } else if (string2.equals("ucs")) {
            this.data = new StringBuffer();
        } else if (string2.equals("code")) {
            this.combining = false;
        } else if (string2.equals("isCombining")) {
            this.data = new StringBuffer();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.data != null) {
            this.data.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXParseException {
        if (string2.equals("marc")) {
            String string4 = this.data.toString();
            if (string4.length() == 6) {
                this.marc = new char[3];
                this.marc[0] = (char)Integer.parseInt(string4.substring(0, 2), 16);
                this.marc[1] = (char)Integer.parseInt(string4.substring(2, 4), 16);
                this.marc[2] = (char)Integer.parseInt(string4.substring(4, 6), 16);
            } else {
                this.marc = new char[1];
                this.marc[0] = (char)Integer.parseInt(string4, 16);
            }
        } else if (string2.equals("ucs")) {
            this.ucs = new Character((char)Integer.parseInt(this.data.toString(), 16));
        } else if (string2.equals("code")) {
            if (this.combining) {
                this.combiningchars.add(this.ucs);
            }
            if (this.charset.get(this.ucs) == null) {
                Hashtable<Integer, char[]> hashtable = new Hashtable<Integer, char[]>(1);
                hashtable.put(this.isocode, this.marc);
                this.charset.put(this.ucs, hashtable);
            } else {
                Hashtable hashtable = (Hashtable)this.charset.get(this.ucs);
                hashtable.put(this.isocode, this.marc);
            }
        } else if (string2.equals("isCombining") && this.data.toString().equals("true")) {
            this.combining = true;
        }
        this.data = null;
    }

    public static void main(String[] stringArray) {
        Object var1_1 = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            File file = new File("C:\\Documents and Settings\\ckeith\\Desktop\\Projects\\Code Tables\\codetables.xml");
            InputSource inputSource = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler reverseCodeTableHandler = new ReverseCodeTableHandler();
            xMLReader.setContentHandler(reverseCodeTableHandler);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }
}

