/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.marc4j.util.CodeTableTracker;
import org.marc4j.util.ReverseCodeTableHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ReverseCodeTable {
    protected static Hashtable charset = null;
    protected static Vector combining = null;

    public static boolean isCombining(Character c) {
        return combining.contains(c);
    }

    public static Hashtable codeTableHash(Character c) {
        Hashtable hashtable = (Hashtable)charset.get(c);
        if (hashtable == null) {
            System.err.println("Not Found: " + c);
            return hashtable;
        }
        return hashtable;
    }

    public static boolean inPreviousCharCodeTable(Character c, CodeTableTracker codeTableTracker) {
        Hashtable hashtable = (Hashtable)charset.get(c);
        if (hashtable == null) {
            System.out.println("Not Found: " + c);
            return false;
        }
        if (hashtable.get(codeTableTracker.getPrevious((byte)0)) != null || hashtable.get(codeTableTracker.getPrevious((byte)1)) != null) {
            codeTableTracker.makePreviousCurrent();
            return true;
        }
        return false;
    }

    public static char getChar(Character c, CodeTableTracker codeTableTracker) {
        Hashtable hashtable = (Hashtable)charset.get(c);
        Integer n = (Integer)hashtable.get(codeTableTracker.getCurrent((byte)0));
        if (n != null) {
            return (char)n.intValue();
        }
        n = (Integer)hashtable.get(codeTableTracker.getCurrent((byte)1));
        if (n != null) {
            return (char)n.intValue();
        }
        return ' ';
    }

    public ReverseCodeTable(InputStream inputStream) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            InputSource inputSource = new InputSource(inputStream);
            ReverseCodeTableHandler reverseCodeTableHandler = new ReverseCodeTableHandler();
            xMLReader.setContentHandler(reverseCodeTableHandler);
            xMLReader.parse(inputSource);
            charset = reverseCodeTableHandler.getCharSets();
            combining = reverseCodeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }

    public ReverseCodeTable(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            File file = new File(string);
            InputSource inputSource = new InputSource(new FileInputStream(file));
            ReverseCodeTableHandler reverseCodeTableHandler = new ReverseCodeTableHandler();
            xMLReader.setContentHandler(reverseCodeTableHandler);
            xMLReader.parse(inputSource);
            charset = reverseCodeTableHandler.getCharSets();
            combining = reverseCodeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }

    public ReverseCodeTable(URI uRI) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            InputSource inputSource = new InputSource(uRI.toURL().openStream());
            ReverseCodeTableHandler reverseCodeTableHandler = new ReverseCodeTableHandler();
            xMLReader.setContentHandler(reverseCodeTableHandler);
            xMLReader.parse(inputSource);
            charset = reverseCodeTableHandler.getCharSets();
            combining = reverseCodeTableHandler.getCombiningChars();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.err.println("Exception: " + exception);
        }
    }
}

