/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marcxml;

import java.io.IOException;
import java.util.Hashtable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.marc4j.MarcReader;
import org.marc4j.marcxml.MarcResult;
import org.marc4j.marcxml.MarcSource;
import org.marc4j.marcxml.MarcXmlHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Converter {
    private TransformerFactory factory;
    private Transformer transformer;
    private Hashtable cache = new Hashtable();

    public void convert(Source source, Result result) throws TransformerException, SAXException, IOException {
        if (source instanceof MarcSource && result instanceof MarcResult) {
            this.convert((MarcSource)source, (MarcResult)result);
        } else {
            Source source2 = null;
            this.convert(source2, source, result);
        }
    }

    public void convert(Source source, Source source2, Result result) throws TransformerException, SAXException, IOException {
        if (result instanceof MarcResult) {
            this.convert(source, (SAXSource)source2, (MarcResult)result);
        } else {
            if (source != null) {
                Templates templates = this.tryCache(source);
                this.transformer = templates.newTransformer();
            } else {
                this.factory = TransformerFactory.newInstance();
                this.transformer = this.factory.newTransformer();
            }
            this.transformer.transform(source2, result);
        }
    }

    private void convert(Source source, SAXSource sAXSource, MarcResult marcResult) throws TransformerException, SAXException, IOException {
        MarcXmlHandler marcXmlHandler = new MarcXmlHandler();
        marcXmlHandler.setMarcHandler(marcResult.getHandler());
        if (source != null) {
            SAXResult sAXResult = new SAXResult(marcXmlHandler);
            Templates templates = this.tryCache(source);
            this.transformer = templates.newTransformer();
            this.transformer.transform(sAXSource, sAXResult);
        } else {
            XMLReader xMLReader = sAXSource.getXMLReader();
            xMLReader.setContentHandler(marcXmlHandler);
            xMLReader.parse(sAXSource.getInputSource());
        }
    }

    private void convert(MarcSource marcSource, MarcResult marcResult) throws IOException {
        MarcReader marcReader = marcSource.getMarcReader() != null ? marcSource.getMarcReader() : new MarcReader();
        marcReader.setMarcHandler(marcResult.getHandler());
        if (marcSource.getReader() != null) {
            marcReader.parse(marcSource.getReader());
        } else if (marcSource.getInputStream() != null) {
            marcReader.parse(marcSource.getInputStream());
        } else if (marcSource.getSystemId() != null) {
            marcReader.parse(marcSource.getSystemId());
        } else {
            throw new IOException("Invalid MarcSource object");
        }
    }

    private synchronized Templates tryCache(Source source) throws TransformerException {
        String string = source.getSystemId();
        Templates templates = (Templates)this.cache.get(string);
        if (templates == null) {
            this.factory = TransformerFactory.newInstance();
            templates = this.factory.newTemplates(source);
            this.cache.put(string, templates);
        }
        return templates;
    }

    public synchronized void clearCache() {
        this.cache = new Hashtable();
    }
}

