/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.marc4j.marc.IllegalAddException;
import org.marc4j.marc.IllegalTagException;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.Tag;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.Verifier;

public class DataField
extends VariableField
implements Serializable {
    private char ind1;
    private char ind2;
    private ArrayList list;

    public DataField() {
        this.list = new ArrayList();
    }

    public DataField(String string) {
        super(string);
        this.list = new ArrayList();
    }

    public DataField(String string, char c, char c2) {
        super(string);
        this.setIndicator1(c);
        this.setIndicator2(c2);
        this.list = new ArrayList();
    }

    public void setTag(String string) {
        if (!Tag.isDataField(string)) {
            throw new IllegalTagException(string, "not a data field identifier");
        }
        super.setTag(string);
    }

    public String getTag() {
        return super.getTag();
    }

    public void setIndicator1(char c) {
        Verifier.checkDataElement(c);
        this.ind1 = c;
    }

    public void setIndicator2(char c) {
        Verifier.checkDataElement(c);
        this.ind2 = c;
    }

    public void add(Subfield subfield) {
        this.list.add(subfield);
    }

    public char getIndicator1() {
        return this.ind1;
    }

    public char getIndicator2() {
        return this.ind2;
    }

    public List getSubfieldList() {
        return this.list;
    }

    public Subfield getSubfield(char c) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Subfield subfield = (Subfield)iterator.next();
            if (subfield.getCode() != c) continue;
            return subfield;
        }
        return null;
    }

    public boolean hasSubfield(char c) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Subfield subfield = (Subfield)iterator.next();
            if (subfield.getCode() != c) continue;
            return true;
        }
        return false;
    }

    public void setSubfieldList(List list) {
        if (list == null) {
            this.list = new ArrayList();
            return;
        }
        this.list = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Subfield) {
                this.add((Subfield)e);
                continue;
            }
            throw new IllegalAddException(e.getClass().getName(), "a collection of subfields can only contain Subfield objects.");
        }
    }

    public String marshal() {
        StringBuffer stringBuffer = new StringBuffer().append(this.ind1).append(this.ind2);
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Subfield subfield = (Subfield)iterator.next();
            stringBuffer.append(subfield.marshal());
        }
        stringBuffer.append('\u001e');
        return stringBuffer.toString();
    }

    public int getLength() {
        return this.marshal().length();
    }
}

