/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.jaxen.expr.AdditiveExpr;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.MultiplicativeExpr;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.RelationalExpr;
import org.jaxen.expr.Step;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.expr.UnionExpr;
import org.jaxen.expr.VariableReferenceExpr;
import org.jaxen.expr.Visitor;

public class XPath2XMLVisitor
implements Visitor {
    protected PrintWriter printer;
    protected int tabIndex;

    public XPath2XMLVisitor() {
        this.printer = new PrintWriter(System.out);
    }

    public XPath2XMLVisitor(PrintWriter printWriter) {
        this.printer = printWriter;
    }

    public void visit(PathExpr pathExpr) {
        this.printLn("<PathExpr>");
        if (pathExpr.getFilterExpr() != null) {
            pathExpr.getFilterExpr().accept(this);
        }
        if (pathExpr.getLocationPath() != null) {
            pathExpr.getLocationPath().accept(this);
        }
        this.printLn("</PathExpr>");
    }

    public void visit(LocationPath locationPath) {
        this.printLn("<LocationPath absolute=\"" + locationPath.isAbsolute() + "\">");
        for (Step step : locationPath.getSteps()) {
            step.accept(this);
        }
        this.printLn("</LocationPath>");
    }

    public void visit(LogicalExpr logicalExpr) {
        this.printLn("<LogicalExpr operator=\"" + logicalExpr.getOperator() + "\">");
        this.printLhsRhs(logicalExpr.getLHS(), logicalExpr.getRHS());
        this.printLn("</LogicalExpr>");
    }

    void printLhsRhs(Expr expr, Expr expr2) {
        ++this.tabIndex;
        this.printLn("<lhsExpr>");
        expr.accept(this);
        this.printLn("</lhsExpr>");
        this.printLn("<rhsExpr>");
        expr2.accept(this);
        this.printLn("</rhsExpr>");
        --this.tabIndex;
    }

    public void visit(EqualityExpr equalityExpr) {
        this.printLn("<EqualityExpr operator=\"" + equalityExpr.getOperator() + "\">");
        this.printLhsRhs(equalityExpr.getLHS(), equalityExpr.getRHS());
        this.printLn("</EqualityExpr>");
    }

    public void visit(FilterExpr filterExpr) {
        this.printLn("<FilterExpr>");
        ++this.tabIndex;
        if (filterExpr.getExpr() != null) {
            filterExpr.getExpr().accept(this);
        }
        Iterator iterator = filterExpr.getPredicates().iterator();
        while (iterator.hasNext()) {
            ((Predicate)iterator.next()).getExpr().accept(this);
        }
        --this.tabIndex;
        this.printLn("</FilterExpr>");
    }

    public void visit(RelationalExpr relationalExpr) {
        this.printLn("<RelationalExpr operator=\"" + relationalExpr.getOperator() + "\">");
        this.printLhsRhs(relationalExpr.getLHS(), relationalExpr.getRHS());
        this.printLn("</RelationalExpr>");
    }

    public void visit(AdditiveExpr additiveExpr) {
        this.printLn("<AdditiveExpr operator=\"" + additiveExpr.getOperator() + "\">");
        this.printLhsRhs(additiveExpr.getLHS(), additiveExpr.getRHS());
        this.printLn("</AdditiveExpr>");
    }

    public void visit(MultiplicativeExpr multiplicativeExpr) {
        this.printLn("<MultiplicativeExpr operator=\"" + multiplicativeExpr.getOperator() + "\">");
        this.printLhsRhs(multiplicativeExpr.getLHS(), multiplicativeExpr.getRHS());
        this.printLn("</MultiplicativeExpr>");
    }

    public void visit(UnaryExpr unaryExpr) {
        this.printLn("<UnaryExpr>");
        unaryExpr.getExpr().accept(this);
        this.printLn("</UnaryExpr>");
    }

    public void visit(UnionExpr unionExpr) {
        this.printLn("<UnionExpr>");
        this.printLhsRhs(unionExpr.getLHS(), unionExpr.getRHS());
        this.printLn("</UnionExpr>");
    }

    public void visit(NumberExpr numberExpr) {
        this.printLn("<NumberExpr>");
        this.printLn(numberExpr.getNumber().toString());
        this.printLn("</NumberExpr>");
    }

    public void visit(LiteralExpr literalExpr) {
        this.printLn("<LiteralExpr literal=\"" + literalExpr.getLiteral() + "\"/>");
    }

    public void visit(VariableReferenceExpr variableReferenceExpr) {
        this.printLn("<VariableReferenceExpr name=\"" + variableReferenceExpr.getVariableName() + "\"/>");
    }

    public void visit(FunctionCallExpr functionCallExpr) {
        this.printLn("<FunctionCallExpr prefix=\"" + functionCallExpr.getPrefix() + "\" functionName=\"" + functionCallExpr.getFunctionName() + "\">");
        Iterator iterator = functionCallExpr.getParameters().iterator();
        ++this.tabIndex;
        this.printLn("<Args>");
        while (iterator.hasNext()) {
            ((Expr)iterator.next()).accept(this);
        }
        this.printLn("</Args>");
        --this.tabIndex;
        this.printLn("</FunctionCallExpr>");
    }

    public void visit(NameStep nameStep) {
        this.printLn("<NameStep prefix=\"" + nameStep.getPrefix() + "\" localName=\"" + nameStep.getLocalName() + "\">");
        Iterator iterator = nameStep.getPredicates().iterator();
        ++this.tabIndex;
        while (iterator.hasNext()) {
            Predicate predicate = (Predicate)iterator.next();
            predicate.accept(this);
        }
        --this.tabIndex;
        this.printLn("</NameStep>");
    }

    public void visit(ProcessingInstructionNodeStep processingInstructionNodeStep) {
        this.printLn("<ProcessingInstructionNodeStep name=\"" + processingInstructionNodeStep.getName() + "\" axis=\"" + processingInstructionNodeStep.getAxis() + ">");
        ++this.tabIndex;
        this.handlePredicates(processingInstructionNodeStep.getPredicates());
        --this.tabIndex;
        this.printLn("</ProcessingInstructionNodeStep>");
    }

    public void visit(AllNodeStep allNodeStep) {
        this.printLn("<AllNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(allNodeStep.getPredicates());
        --this.tabIndex;
        this.printLn("</AllNodeStep>");
    }

    public void visit(TextNodeStep textNodeStep) {
        this.printLn("<TextNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(textNodeStep.getPredicates());
        --this.tabIndex;
        this.printLn("</TextNodeStep>");
    }

    public void visit(CommentNodeStep commentNodeStep) {
        this.printLn("<CommentNodeStep>");
        ++this.tabIndex;
        this.handlePredicates(commentNodeStep.getPredicates());
        --this.tabIndex;
        this.printLn("</CommentNodeStep>");
    }

    public void visit(Predicate predicate) {
        this.printLn("<Predicate>");
        ++this.tabIndex;
        predicate.getExpr().accept(this);
        --this.tabIndex;
        this.printLn("</Predicate>");
    }

    protected void printLn(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tabIndex; ++i) {
            stringBuffer.append("\t");
        }
        stringBuffer.append(string);
        this.printer.println(stringBuffer.toString());
    }

    protected void handlePredicates(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Predicate)iterator.next()).accept(this);
            }
        }
    }
}

