/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;

    public HostFileNameParser(int n) {
        this.defaultPort = n;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c);
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer();
        Authority authority = this.extractToPath(string, stringBuffer);
        UriParser.canonicalizePath(stringBuffer, 0, stringBuffer.length(), this);
        UriParser.fixSeparators(stringBuffer);
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string2 = stringBuffer.toString();
        return new GenericFileName(authority.scheme, authority.hostName, authority.port, this.defaultPort, authority.userName, authority.password, string2, fileType);
    }

    protected Authority extractToPath(String string, StringBuffer stringBuffer) throws FileSystemException {
        String string2;
        String string3;
        Authority authority = new Authority();
        authority.scheme = UriParser.extractScheme(string, stringBuffer);
        if (stringBuffer.length() < 2 || stringBuffer.charAt(0) != '/' || stringBuffer.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", string);
        }
        stringBuffer.delete(0, 2);
        String string4 = this.extractUserInfo(stringBuffer);
        if (string4 != null) {
            int n = string4.indexOf(58);
            if (n == -1) {
                string3 = string4;
                string2 = null;
            } else {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            string3 = null;
            string2 = null;
        }
        authority.userName = UriParser.decode(string3);
        authority.password = UriParser.decode(string2);
        String string5 = this.extractHostName(stringBuffer);
        if (string5 == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", string);
        }
        authority.hostName = string5.toLowerCase();
        authority.port = this.extractPort(stringBuffer, string);
        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", string);
        }
        return authority;
    }

    protected String extractUserInfo(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '@') {
                String string = stringBuffer.substring(0, i);
                stringBuffer.delete(0, i + 1);
                return string;
            }
            if (c == '/' || c == '?') break;
        }
        return null;
    }

    protected String extractHostName(StringBuffer stringBuffer) {
        char c;
        int n;
        int n2 = stringBuffer.length();
        for (n = 0; n < n2 && (c = stringBuffer.charAt(n)) != '/' && c != ';' && c != '?' && c != ':' && c != '@' && c != '&' && c != '=' && c != '+' && c != '$' && c != ','; ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string = stringBuffer.substring(0, n);
        stringBuffer.delete(0, n);
        return string;
    }

    protected int extractPort(StringBuffer stringBuffer, String string) throws FileSystemException {
        char c;
        int n;
        if (stringBuffer.length() < 1 || stringBuffer.charAt(0) != ':') {
            return -1;
        }
        int n2 = stringBuffer.length();
        for (n = 1; n < n2 && (c = stringBuffer.charAt(n)) >= '0' && c <= '9'; ++n) {
        }
        String string2 = stringBuffer.substring(1, n);
        stringBuffer.delete(0, n);
        if (string2.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", string);
        }
        return Integer.parseInt(string2);
    }

    protected static class Authority {
        public String scheme;
        public String hostName;
        public String userName;
        public String password;
        public int port;

        protected Authority() {
        }
    }
}

