/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.toolkit;

import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.file.LoadAction;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultipleDocumentEditor
extends JFrame
implements ChangeListener {
    private JToolBar toolBar;
    private JTabbedPane tabbedPane;
    private ArrayList containers;

    private MultipleDocumentEditor() {
        super("Multiple editor");
        this.setSize(550, 400);
        this.setDefaultCloseOperation(2);
        this.toolBar = new JToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JComponent jComponent = (JComponent)this.tabbedPane.getSelectedComponent();
        if (jComponent instanceof IView) {
            IView iView = (IView)((Object)jComponent);
            XMLContainer xMLContainer = iView.getContainer();
            ActionModel.resetActionState(xMLContainer.getEditor(), xMLContainer);
        }
    }

    public ArrayList getXMLContainers() {
        return this.containers;
    }

    public static MultipleDocumentEditor showEditor(String[] stringArray) throws FileNotFoundException, IOException {
        MultipleDocumentEditor multipleDocumentEditor = new MultipleDocumentEditor();
        ActionModel.buildToolBar(multipleDocumentEditor.toolBar);
        multipleDocumentEditor.containers = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            XMLContainer xMLContainer = new XMLContainer(true);
            xMLContainer.setToolBarAvailable(false);
            multipleDocumentEditor.containers.add(xMLContainer);
            try {
                LoadAction.loadInBuffer(xMLContainer, stringArray[i]);
            }
            catch (Throwable throwable) {
                multipleDocumentEditor.dispose();
                if (throwable instanceof FileNotFoundException) {
                    throw (FileNotFoundException)throwable;
                }
                throw new IOException(throwable.getMessage());
            }
            String string = stringArray[i];
            int n = string.lastIndexOf("/");
            if (n == -1) {
                n = string.lastIndexOf("\\");
            }
            if (n > -1) {
                string = string.substring(n + 1);
            }
            multipleDocumentEditor.tabbedPane.addTab(string, xMLContainer.getView());
        }
        multipleDocumentEditor.setTitle("JXMLPad");
        multipleDocumentEditor.setVisible(true);
        return multipleDocumentEditor;
    }

    public void dispose() {
        if (this.containers == null) {
            return;
        }
        for (int i = 0; i < this.containers.size(); ++i) {
            XMLContainer xMLContainer = (XMLContainer)this.containers.get(i);
            xMLContainer.dispose();
        }
    }

    public static MultipleDocumentEditor showEditor(File file, FileFilter fileFilter) throws FileNotFoundException, IOException {
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (fileFilter != null && !fileFilter.accept(file2) || !file2.isFile()) continue;
            arrayList.add(file2.toString());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return MultipleDocumentEditor.showEditor(stringArray2);
    }

    public static void main(String[] stringArray) throws Throwable {
        MultipleDocumentEditor.showEditor(new File("/home/japisoft/xml-samples"), null);
    }
}

