/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.elementview.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

class FastTableCellRenderer
extends JComponent
implements TableCellRenderer {
    private boolean selected;
    private Dimension d = new Dimension(100, 20);
    private int textY;
    private int fmHeight;
    FontMetrics fm;
    private Color prefixNameColor;
    private Color highlightColor = null;
    private Color lowlightColor = null;
    String content = null;
    int row = 0;
    private Color textColor = Color.black;

    public FastTableCellRenderer() {
        this.setFont(UIManager.getFont("xmlpad.tableElementView.font"));
        this.setColorForPrefixName(UIManager.getColor("xmlpad.tableElementView.prefixNameColor"));
        this.setHighlightColor(UIManager.getColor("xmlpad.tableElementView.highlightColor"));
        this.setLowlightColor(UIManager.getColor("xmlpad.tableElementView.lowlightColor"));
    }

    public void setFont(Font font) {
        if (font == null) {
            font = new Font(null, 0, 10);
        }
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.fmHeight = this.fm.getHeight() + 2;
        this.textY = this.fm.getAscent();
    }

    public void setColorForPrefixName(Color color) {
        if (color == null) {
            color = new Color(230, 230, 230);
        }
        this.prefixNameColor = color;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            color = new Color(255, 255, 255);
        }
        this.highlightColor = color;
    }

    public void setLowlightColor(Color color) {
        if (color == null) {
            color = new Color(240, 240, 240);
        }
        this.lowlightColor = color;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.content = (String)object;
        this.selected = bl;
        this.row = n;
        if (n < 2) {
            this.setBackground(this.prefixNameColor);
        } else {
            this.setBackground(n % 2 == 0 ? this.highlightColor : this.lowlightColor);
        }
        return this;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.content != null) {
            graphics.setColor(this.textColor);
            graphics.drawString(this.content, 0, this.textY);
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void repaint() {
    }
}

