/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.xmlpad.editor.CommonView;
import com.japisoft.xmlpad.editor.LineElement;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.editor.XMLViewable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

class XMLTextView
extends CommonView
implements XMLViewable {
    private int oldLineIndex = -1;
    private int oldStartUnderlineX1 = -1;
    private int oldStartUnderlineX2 = -1;
    private int oldStartUnderlineY = -1;
    private int oldStopUnderlineX1 = -1;
    private int oldStopUnderlineX2 = -1;
    private int oldStopUnderlineY = -1;
    private String oldElement = "";

    public XMLTextView(Element element, boolean bl) {
        super(element);
        this.visibleSpace = bl;
    }

    public void setDisplaySpace(boolean bl) {
        this.visibleSpace = bl;
    }

    public void setSyntaxColor(boolean bl) {
        if (!bl) {
            this.lp = null;
        }
    }

    public void setDTDMode(boolean bl) {
        if (this.lp != null) {
            this.lp.setDTDMode(bl);
        }
    }

    public void drawLine(int n, Graphics graphics, int n2, int n3) {
        block26: {
            Serializable serializable;
            Document document = this.getDocument();
            XMLEditor xMLEditor = (XMLEditor)this.getContainer();
            Font font = xMLEditor.getFont();
            int n4 = -1;
            int n5 = -1;
            String string = null;
            if (xMLEditor instanceof XMLEditor && ((XMLEditor)(serializable = xMLEditor)).getXMLContainer() != null && ((XMLEditor)serializable).getXMLContainer().getCurrentElementNode() != null && !((XMLEditor)serializable).getXMLContainer().getCurrentElementNode().isClosedLeaf()) {
                n4 = ((XMLEditor)serializable).getXMLContainer().getCurrentElementNode().getStartingOffset();
                n5 = ((XMLEditor)serializable).getXMLContainer().getCurrentElementNode().getStoppingOffset();
                if (((XMLEditor)serializable).getXMLContainer().getCurrentElementNode().isTag()) {
                    string = ((XMLEditor)serializable).getXMLContainer().getCurrentElementNode().getContent();
                }
            }
            XMLDocument xMLDocument = document instanceof XMLDocument ? (XMLDocument)document : null;
            serializable = graphics.getFontMetrics();
            Color color = this.getDefaultColor();
            Font font2 = xMLEditor.getFont();
            try {
                Element element = this.getElement().getElement(n);
                int n6 = element.getStartOffset();
                int n7 = element.getEndOffset();
                document.getText(n6, n7 - (n6 + 1), this.line);
                if (this.lp == null) {
                    graphics.setColor(color);
                    Utilities.drawTabbedText(this.line, n2, n3, graphics, (TabExpander)this, 0);
                    break block26;
                }
                int n8 = 0;
                Vector vector = this.lp.parse(this.line, n);
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < vector.size(); ++i) {
                    char c;
                    int n9;
                    int n10;
                    Object object;
                    LineElement lineElement = (LineElement)vector.get(i);
                    String string2 = lineElement.content;
                    int n11 = lineElement.type;
                    Color color2 = LineElement.getColor(xMLEditor, false, false, n11, 0, 0);
                    if (color2 == null) {
                        color2 = color;
                    }
                    if (lineElement.type == 12 && string2 != null && xMLEditor.hasColorForPrefix(string2)) {
                        color2 = xMLEditor.getColorForPrefix(string2);
                    }
                    if (lineElement.type == 5 && string2 != null) {
                        if (xMLEditor.hasColorForTag(string2)) {
                            color2 = xMLEditor.getColorForTag(string2);
                        }
                        if (i >= 2) {
                            object = (LineElement)vector.get(i - 2);
                            if (((LineElement)object).type == 12 && xMLEditor.hasColorForPrefix(((LineElement)object).content)) {
                                color2 = xMLEditor.getColorForPrefix(((LineElement)object).content);
                            }
                        }
                    }
                    if (lineElement.type == 8 && string2 != null && xMLEditor.hasColorForAttribute(string2)) {
                        color2 = xMLEditor.getColorForAttribute(string2);
                    }
                    object = font2;
                    graphics.setColor(color2);
                    this.line.count = string2 != null ? string2.length() : 0;
                    int n12 = n2;
                    try {
                        n2 = Utilities.drawTabbedText(this.line, n2, n3, graphics, (TabExpander)this, n8);
                        if (this.visibleSpace) {
                            n10 = n12;
                            for (n9 = 0; n9 < this.line.count; ++n9) {
                                c = this.line.array[this.line.offset + n9];
                                if (c == ' ' || c == '\t' || c == '\u00a0') {
                                    graphics.setColor(Color.GRAY);
                                    graphics.drawLine(n10, n3, n10 + 2, n3);
                                    graphics.drawLine(n10 + 2, n3, n10 + 2, n3 + 2);
                                }
                                if (c == '\t') {
                                    n10 = (int)this.nextTabStop(n10, this.line.offset + n9);
                                    continue;
                                }
                                n10 += ((FontMetrics)serializable).charWidth(c);
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    n10 = n8;
                    n8 += this.line.count;
                    if (lineElement.type == 5) {
                        n9 = 0;
                        c = '\u0000';
                        boolean bl3 = false;
                        if (string != null && string.equals(lineElement.content)) {
                            graphics.setColor(xMLEditor.getBackground());
                            graphics.drawLine(this.oldStartUnderlineX1, this.oldStartUnderlineY, this.oldStartUnderlineX2, this.oldStartUnderlineY);
                            graphics.drawLine(this.oldStopUnderlineX1, this.oldStopUnderlineY, this.oldStopUnderlineX2, this.oldStopUnderlineY);
                            bl3 = true;
                        } else {
                            c = '\u0001';
                        }
                        if (bl3 && n4 > -1 && n6 + n10 >= n4 && n6 + n10 <= n4 + this.line.count) {
                            if (c != '\u0000') {
                                this.oldStartUnderlineX1 = n12;
                                this.oldStartUnderlineX2 = n2;
                                this.oldStartUnderlineY = n3 + 2;
                            }
                            this.drawUnderline(n12, n2, n3 + 2, LineElement.getColor(xMLEditor, false, false, 13, 0, 0), graphics);
                            n9 = 1;
                        }
                        if (bl3 && n9 == 0 && n5 > -1 && n6 + n8 >= n5 - this.line.count && n6 + n8 <= n5) {
                            if (c != '\u0000') {
                                this.oldStopUnderlineX1 = n12;
                                this.oldStopUnderlineX2 = n2;
                                this.oldStopUnderlineY = n3 + 2;
                            }
                            this.drawUnderline(n12, n2, n3 + 2, LineElement.getColor(xMLEditor, false, false, 13, 0, 0), graphics);
                        }
                    }
                    this.line.offset += this.line.count;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    private void drawUnderline(int n, int n2, int n3, Color color, Graphics graphics) {
        graphics.setColor(LineElement.getColor((XMLEditor)this.getContainer(), false, false, 13, 0, 0));
        int n4 = n3;
        for (int i = n; i <= n2; i += 2) {
            graphics.drawLine(i, n4, i, n4);
        }
    }

    protected Color getDefaultColor() {
        return this.getContainer().getForeground();
    }
}

