/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.treefilebrowser.FileTreeNode;
import com.japisoft.treefilebrowser.JTreeFileBrowser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class FileTreeModel
implements TreeModel {
    private FileTreeNode root = null;
    private boolean aUnitSupport = false;
    private int orderingMode = JTreeFileBrowser.DIRECTORY_FIRST;
    private ArrayList listeners = null;

    FileTreeModel() {
        this.root = new FileTreeNode();
    }

    void setAUnitSupport(boolean bl) {
        this.aUnitSupport = bl;
    }

    boolean isAUnitSupport() {
        return this.aUnitSupport;
    }

    void setOrderingMode(int n) {
        this.orderingMode = n;
    }

    int getOrderingMode() {
        return this.orderingMode;
    }

    void updateFirst() {
        this.update(this.root);
    }

    void update(FileTreeNode fileTreeNode) {
        if (!fileTreeNode.resolved) {
            if (fileTreeNode == this.root) {
                File[] fileArray = File.listRoots();
                if (fileArray != null) {
                    boolean bl = false;
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file = fileArray[i];
                        bl = file.toString().toLowerCase().startsWith("a:");
                        if (bl && !this.aUnitSupport || !file.canRead()) continue;
                        FileTreeNode fileTreeNode2 = new FileTreeNode(file);
                        fileTreeNode2.root = true;
                        fileTreeNode.add(fileTreeNode2);
                    }
                }
            } else {
                File[] fileArray;
                File file = fileTreeNode.getFile();
                if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                    Arrays.sort(fileArray, new FileItemComparator());
                    for (int i = 0; i < fileArray.length; ++i) {
                        fileTreeNode.add(new FileTreeNode(fileArray[i]));
                    }
                }
            }
            fileTreeNode.resolved = true;
        }
    }

    public Object getChild(Object object, int n) {
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        if (!fileTreeNode.resolved) {
            this.update(fileTreeNode);
        }
        return fileTreeNode.getChildAt(n);
    }

    public int getChildCount(Object object) {
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        if (!fileTreeNode.resolved) {
            this.update(fileTreeNode);
        }
        return fileTreeNode.getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        if (!fileTreeNode.resolved) {
            this.update(fileTreeNode);
        }
        return fileTreeNode.getIndex((TreeNode)object2);
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        if (fileTreeNode.resolved) {
            return fileTreeNode.getChildCount() == 0;
        }
        if (fileTreeNode == this.root) {
            return false;
        }
        return !fileTreeNode.getFile().isDirectory();
    }

    public void reload(TreePath treePath) {
        FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
        fileTreeNode.removeAllChildren();
        fileTreeNode.resolved = false;
        this.update(fileTreeNode);
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                TreeModelListener treeModelListener = (TreeModelListener)this.listeners.get(i);
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, treePath));
            }
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners != null) {
            this.listeners.remove(treeModelListener);
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    class FileItemComparator
    implements Comparator {
        FileItemComparator() {
        }

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            if (file.isDirectory() && !file2.isDirectory()) {
                return FileTreeModel.this.orderingMode == JTreeFileBrowser.DIRECTORY_FIRST ? -1 : 1;
            }
            if (!file.isDirectory() && file2.isDirectory()) {
                return FileTreeModel.this.orderingMode == JTreeFileBrowser.DIRECTORY_FIRST ? 1 : -1;
            }
            return file.compareTo(file2);
        }
    }
}

