/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor.ui;

import com.japisoft.framework.xml.refactor.RefactorManager;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class RefactorTable
extends JTable {
    private String[] actions;
    private static int MAX = 30;

    public RefactorTable(String string) {
        super(new DefaultTableModel(new String[]{"Old Value (V1)", "Action", "New Value (V2)"}, MAX));
        this.actions = RefactorManager.getRefactorActions(string);
        this.getColumnModel().getColumn(1).setCellRenderer(new CustomTableRenderer());
        this.getColumnModel().getColumn(1).setCellEditor(new CustomTableEditor());
        this.getColumnModel().getColumn(1).setPreferredWidth(120);
    }

    public void init(int n, String string) {
        if (string != null) {
            this.getModel().setValueAt(string, n, 0);
        }
    }

    private boolean isValidAction(int n) {
        if (this.getValueAt(n, 0) != null && this.getValueAt(n, 1) != null) {
            String string = (String)this.getValueAt(n, 1);
            if (string.indexOf("V2") > -1) {
                return this.getValueAt(n, 2) != null;
            }
            return true;
        }
        return false;
    }

    public RefactorAction[] getActions() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isValidAction(i)) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        RefactorAction[] refactorActionArray = new RefactorAction[n];
        n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isValidAction(i)) continue;
            RefactorAction refactorAction = new RefactorAction((String)this.getValueAt(i, 1), (String)this.getValueAt(i, 0), (String)this.getValueAt(i, 2));
            refactorActionArray[n++] = refactorAction;
        }
        return refactorActionArray;
    }

    public void setActions(RefactorAction[] refactorActionArray) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        if (refactorActionArray != null) {
            for (int i = 0; i < refactorActionArray.length; ++i) {
                defaultTableModel.addRow(new Object[]{refactorActionArray[i].getOldValue(), refactorActionArray[i].getAction(), refactorActionArray[i].getNewValue()});
            }
        }
    }

    class CustomTableEditor
    implements TableCellEditor,
    ItemListener,
    MouseListener {
        private JComboBox cb;
        CellEditorListener l;

        CustomTableEditor() {
            this.cb = new JComboBox<String>(RefactorTable.this.actions);
            this.cb.addItemListener(this);
            RefactorTable.this.addMouseListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cb.setSelectedItem((String)object);
            return this.cb;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.l = cellEditorListener;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.l != null) {
                this.l.editingStopped(null);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.itemStateChanged(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return this.cb.getSelectedItem();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean stopCellEditing() {
            return false;
        }
    }

    class CustomTableRenderer
    implements TableCellRenderer {
        private JLabel cb = new JLabel();

        public CustomTableRenderer() {
            this.cb.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.cb.setText((String)object);
            if (bl) {
                this.cb.setBackground(jTable.getSelectionBackground());
                this.cb.setForeground(jTable.getSelectionForeground());
            } else {
                this.cb.setBackground(jTable.getBackground());
                this.cb.setForeground(jTable.getForeground());
            }
            return this.cb;
        }
    }
}

