/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor.elements;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.elements.AbstractRefactor;
import com.japisoft.framework.xml.refactor.elements.ElementProxyNode;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementRefactor
extends AbstractRefactor {
    public static String[] ACTIONS = new String[]{"(V1) RENAME TO (V2)", "DELETE (V1)", "ADD ATTR(V2) to (V1)", "(V1) : ATTR(S) TO ELEMENT(S)", "(V1) : TO ATTR(S)"};

    public ElementRefactor() {
        super((short)1);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public String getName() {
        return "Element";
    }

    protected Node preRefactorIt(Node node, RefactorAction refactorAction) {
        if ("(V1) : TO ATTR(S)".equals(refactorAction.getAction())) {
            int n;
            NodeList nodeList = node.getChildNodes();
            ArrayList<Node> arrayList = null;
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (!refactorAction.matchOldValue(nodeList.item(n).getLocalName())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Node>();
                }
                arrayList.add(nodeList.item(n));
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    Node node2 = (Node)arrayList.get(n);
                    node.removeChild((Node)arrayList.get(n));
                    Element element = (Element)node;
                    String string = ((Node)arrayList.get(n)).getLocalName();
                    if (element.getAttributeNode(string) != null) {
                        String string2 = string;
                        for (int i = 2; i < 100 && element.getAttributeNode(string = string2 + i) != null; ++i) {
                        }
                    }
                    element.setAttribute(string, ((Node)arrayList.get(n)).getTextContent());
                }
            }
        }
        return node;
    }

    protected Node refactorIt(Node node, RefactorAction refactorAction) {
        NamedNodeMap namedNodeMap;
        Element element = (Element)node;
        if ("(V1) RENAME TO (V2)".equals(refactorAction.getAction())) {
            if (refactorAction.matchOldValue(node.getLocalName())) {
                ElementProxyNode elementProxyNode = new ElementProxyNode(element);
                if (!refactorAction.isNewValueEmpty()) {
                    elementProxyNode.setNewLocalName(refactorAction.getNewValue());
                    return elementProxyNode;
                }
            }
        } else if ("DELETE (V1)".equals(refactorAction.getAction())) {
            if (node.getLocalName().equals(refactorAction.getOldValue())) {
                return null;
            }
        } else if ("ADD ATTR(V2) to (V1)".equals(refactorAction.getAction())) {
            if (refactorAction.matchOldValue(node.getLocalName()) && !refactorAction.isNewValueEmpty()) {
                String string = refactorAction.getNewValue();
                int n = string.indexOf("=");
                if (n > -1) {
                    element.setAttribute(string.substring(0, n), string.substring(n + 1));
                } else {
                    element.setAttribute(string, "");
                }
            }
        } else if ("(V1) : ATTR(S) TO ELEMENT(S)".equals(refactorAction.getAction()) && refactorAction.matchOldValue(node.getLocalName()) && (namedNodeMap = node.getAttributes()) != null) {
            Node node2;
            int n;
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                node2 = namedNodeMap.item(n);
                if (node2.getNodeName().indexOf(":") != -1) continue;
                Document document = node.getOwnerDocument();
                Element element2 = document.createElement(node2.getNodeName());
                element2.appendChild(document.createTextNode(node2.getNodeValue()));
                node.appendChild(element2);
            }
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                node2 = namedNodeMap.item(n);
                if (node2.getNodeName().indexOf(":") != -1) continue;
                --n;
                namedNodeMap.removeNamedItem(node2.getNodeName());
            }
        }
        return node;
    }

    public void initTable(RefactorTable refactorTable, SimpleNode simpleNode) {
        refactorTable.init(0, simpleNode.getContent());
    }
}

