/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor;

import com.japisoft.framework.xml.refactor.RefactorManager;
import com.japisoft.framework.xml.refactor.elements.RefactorObj;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Refactor {
    public static int INDENT_SIZE_PROPERTY = 1;
    public static String INDENT_CHAR_PROPERTY = "\t";
    public static boolean CANONICAL = false;
    public static boolean PRESERVE_EMPTY_ATTRIBUTE_VALUE = true;
    private RefactorObj[] params;
    private String contextRefactor;
    private String XMLEncoding = null;
    private boolean replaceLt = true;
    private boolean replaceGt = true;
    private boolean replaceAmp = true;
    private boolean replaceQuote = true;
    private boolean replaceAPos = true;

    public String refactor(Node node, RefactorObj[] refactorObjArray) {
        StringBuffer stringBuffer = new StringBuffer();
        this.params = refactorObjArray;
        if (this.contextRefactor != null) {
            node = this.resolveXPathContext(this.contextRefactor, node);
        }
        this.print(0, node, stringBuffer);
        if (refactorObjArray != null) {
            for (int i = 0; i < refactorObjArray.length; ++i) {
                refactorObjArray[i].stop();
            }
        }
        return stringBuffer.toString();
    }

    private Node resolveXPathContext(String string, Node node) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        int n = string.indexOf("/");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        int n2 = 0;
        String string3 = string2;
        if (string2.endsWith("]")) {
            int n3 = string2.indexOf("[");
            string3 = string2.substring(0, n3);
            n2 = Integer.parseInt(string2.substring(n3 + 1, string2.length() - 1));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getLocalName().equals(string3) || --n2 > 0) continue;
            if (n == -1) {
                return node2;
            }
            return this.resolveXPathContext(string.substring(n + 1), node2);
        }
        return node;
    }

    public String refactor(Node node) {
        return this.refactor(node, RefactorManager.getRefactors());
    }

    public String refactor(File file, RefactorObj[] refactorObjArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return this.refactor(document, refactorObjArray);
    }

    public String refactor(File file) throws Exception {
        return this.refactor(file, RefactorManager.getRefactors());
    }

    public String format(File file) throws Exception {
        return this.refactor(file, null);
    }

    public void setContext(String string) {
        this.contextRefactor = string;
    }

    public String getXMLEncoding() {
        if (this.XMLEncoding == null) {
            this.XMLEncoding = "UTF-8";
        }
        return this.XMLEncoding;
    }

    private Node refactorIt(Node node) {
        if (node == null) {
            return null;
        }
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if ((node = this.params[i].refactor(node)) != null) continue;
                return null;
            }
            return node;
        }
        return node;
    }

    private Node preRefactorIt(Node node) {
        if (node == null) {
            return null;
        }
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if ((node = this.params[i].preRefactor(node)) != null) continue;
                return null;
            }
            return node;
        }
        return node;
    }

    public void print(int n, Node node, StringBuffer stringBuffer) {
        Object object;
        if ((node = this.preRefactorIt(node)) == null) {
            return;
        }
        if ((node = this.refactorIt(node)) == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                object = (DocumentType)node;
                stringBuffer.append("<!DOCTYPE ");
                stringBuffer.append(object.getName());
                if (object.getPublicId() == null) {
                    if (object.getSystemId() != null) {
                        stringBuffer.append(" SYSTEM \"");
                        stringBuffer.append(object.getSystemId());
                        stringBuffer.append("\"");
                    }
                } else {
                    stringBuffer.append(" PUBLIC \"");
                    stringBuffer.append(object.getPublicId());
                    stringBuffer.append("\" ");
                    if (object.getSystemId() != null) {
                        stringBuffer.append("\"");
                        stringBuffer.append(object.getSystemId());
                        stringBuffer.append("\"");
                    }
                }
                if (object.getInternalSubset() != null) {
                    stringBuffer.append("[").append(object.getInternalSubset()).append("]");
                }
                stringBuffer.append(">\n");
                break;
            }
            case 9: {
                int n2;
                object = (Document)node;
                String string = null;
                String string2 = "1.0";
                stringBuffer.append("<?xml version=\"").append(string2).append("\"");
                if (string != null) {
                    stringBuffer.append(" encoding=\"").append(string).append("\"");
                    this.XMLEncoding = string;
                }
                stringBuffer.append("?>\n");
                NodeList nodeList = node.getChildNodes();
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    this.print(n, nodeList.item(n2), stringBuffer);
                }
                break;
            }
            case 1: {
                int n2;
                if (!(node.getParentNode() instanceof Document)) {
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append(INDENT_CHAR_PROPERTY);
                    }
                }
                stringBuffer.append('<');
                object = node.getPrefix();
                if (object != null && ((String)object).length() > 0) {
                    stringBuffer.append((String)object);
                    stringBuffer.append(':');
                }
                if (node.getLocalName() != null) {
                    stringBuffer.append(node.getLocalName());
                } else {
                    stringBuffer.append(node.getNodeName());
                }
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    if ((attr = (Attr)this.refactorIt(attr)) == null) continue;
                    stringBuffer.append(' ');
                    stringBuffer.append(attr.getNodeName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(this.normalize(attr.getNodeValue(), PRESERVE_EMPTY_ATTRIBUTE_VALUE));
                    stringBuffer.append('\"');
                }
                if (!node.hasChildNodes()) {
                    stringBuffer.append("/>\n");
                } else if (node.getChildNodes().getLength() != 1 || !(node.getChildNodes().item(0) instanceof Text)) {
                    stringBuffer.append(">\n");
                } else {
                    stringBuffer.append(">");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n3 = nodeList.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    this.print(n + INDENT_SIZE_PROPERTY, nodeList.item(n2), stringBuffer);
                }
                break;
            }
            case 5: {
                if (bl) {
                    object = node.getChildNodes();
                    if (object == null) break;
                    int n4 = object.getLength();
                    for (int i = 0; i < n4; ++i) {
                        stringBuffer.append(object.item(i));
                    }
                    break;
                }
                stringBuffer.append('&');
                stringBuffer.append(node.getNodeName());
                stringBuffer.append(';');
                break;
            }
            case 4: {
                if (bl) {
                    stringBuffer.append(this.normalize(node.getNodeValue(), true));
                    break;
                }
                stringBuffer.append("<![CDATA[");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>");
                break;
            }
            case 3: {
                stringBuffer.append(this.normalize(node.getNodeValue(), false));
                break;
            }
            case 7: {
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName());
                object = node.getNodeValue();
                if (object != null && ((String)object).length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append((String)object);
                }
                stringBuffer.append("?>");
                break;
            }
            case 8: {
                stringBuffer.append("<!--");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("-->\n");
            }
        }
        if (s == 1 && node.hasChildNodes()) {
            if (!(node.getParentNode() instanceof Document || (object = node.getChildNodes()).getLength() == 1 && node.getFirstChild() instanceof Text)) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(INDENT_CHAR_PROPERTY);
                }
            }
            stringBuffer.append("</");
            if (node.getPrefix() != null) {
                stringBuffer.append(node.getPrefix() + ":");
            }
            if (node.getLocalName() != null) {
                stringBuffer.append(node.getLocalName());
            } else {
                stringBuffer.append(node.getNodeName());
            }
            stringBuffer.append(">\n");
        }
    }

    public boolean isReplaceAmp() {
        return this.replaceAmp;
    }

    public void setReplaceAmp(boolean bl) {
        this.replaceAmp = bl;
    }

    public boolean isReplaceAPos() {
        return this.replaceAPos;
    }

    public void setReplaceAPos(boolean bl) {
        this.replaceAPos = bl;
    }

    public boolean isReplaceGt() {
        return this.replaceGt;
    }

    public void setReplaceGt(boolean bl) {
        this.replaceGt = bl;
    }

    public boolean isReplaceLt() {
        return this.replaceLt;
    }

    public void setReplaceLt(boolean bl) {
        this.replaceLt = bl;
    }

    public boolean isReplaceQuote() {
        return this.replaceQuote;
    }

    public void setReplaceQuote(boolean bl) {
        this.replaceQuote = bl;
    }

    protected String normalize(String string, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = CANONICAL;
        boolean bl3 = true;
        boolean bl4 = true;
        int n2 = string != null ? string.length() : 0;
        block8: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\n') {
                bl3 = false;
            }
            bl4 = c == ' ' && bl || c == '\n' ? bl4 : false;
            switch (c) {
                case '<': {
                    if (this.isReplaceLt()) {
                        stringBuffer.append("&lt;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '>': {
                    if (this.isReplaceGt()) {
                        stringBuffer.append("&gt;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '&': {
                    if (n + 4 < n2 && string.charAt(n + 1) == '#' && string.charAt(n + 2) == '1' && string.charAt(n + 3) == '0' && string.charAt(n + 4) == ';') {
                        stringBuffer.append("&#10;");
                        n += 4;
                        continue block8;
                    }
                    if (this.isReplaceAmp()) {
                        stringBuffer.append("&amp;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\"': {
                    if (this.isReplaceQuote()) {
                        stringBuffer.append("&quot;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\'': {
                    if (this.isReplaceAPos()) {
                        stringBuffer.append("&apos;");
                        continue block8;
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (bl2) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block8;
                    }
                }
                default: {
                    if (bl4) continue block8;
                    stringBuffer.append(c);
                }
            }
        }
        if (bl3) {
            if (bl) {
                return string;
            }
            return "";
        }
        String string2 = stringBuffer.toString();
        int n3 = -1;
        n = string2.length() - 1;
        while (n >= 0 && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t' || string2.charAt(n) == '\n' || string2.charAt(n) == '\r')) {
            n3 = n--;
        }
        if (n3 != -1) {
            return string2.substring(0, n3);
        }
        return string2;
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(namedNodeMap.item(i));
        }
        Attr[] attrArray = new Attr[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            attrArray[n] = (Attr)arrayList.get(n);
        }
        n2 = attrArray.length;
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }
}

