/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class FastLabel
extends JComponent
implements PropertyChangeListener {
    private String text;
    private boolean border;
    private boolean center;
    private boolean error;
    private Icon icon;
    int xtext = 4;
    int xicon = 0;
    int hc = 0;
    boolean underlineMode = false;
    private Color underlineColor = null;
    Dimension preferredSize = null;

    public FastLabel() {
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
        this.setFont(UIManager.getFont("Label.font"));
        this.setOpaque(true);
        this.addPropertyChangeListener(this);
    }

    public FastLabel(boolean bl) {
        this();
        this.border = bl;
    }

    public FastLabel(boolean bl, boolean bl2) {
        this(bl);
        this.center = bl2;
    }

    public FastLabel(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2);
        this.error = bl3;
    }

    public void removeNotify() {
        super.removeNotify();
        this.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("font".equals(propertyChangeEvent.getPropertyName())) {
            this.computeInnerSize();
        }
    }

    public void setText(String string) {
        this.text = string;
        this.computeInnerSize();
        if (this.error) {
            this.setToolTipText(string);
        }
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.computeInnerSize();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setUnderlineMode(boolean bl) {
        this.underlineMode = bl;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.border) {
            graphics.setColor(Color.GRAY);
            graphics.draw3DRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, true);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics, 0, 0);
        }
        if (this.text != null) {
            graphics.setColor(this.error ? Color.RED : this.getForeground());
            graphics.drawString(this.text, this.xtext, this.hc);
        }
        if (this.underlineMode) {
            if (this.underlineColor != null) {
                graphics.setColor(this.underlineColor);
            }
            graphics.drawLine(this.xtext, this.hc + 2, this.preferredSize.width, this.hc + 2);
        }
    }

    public void setUnderlineColor(Color color) {
        this.underlineColor = color;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            return super.getPreferredSize();
        }
        return this.preferredSize;
    }

    private void computeInnerSize() {
        if (this.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        this.xtext = 0;
        if (this.text != null) {
            n = fontMetrics.stringWidth(this.text);
        }
        if (this.center && this.text != null) {
            this.xtext = 2 + (this.getWidth() - n / 2);
        }
        if (this.icon != null) {
            this.xtext += this.icon.getIconWidth() + 2;
        }
        this.hc = Math.max(fontMetrics.getAscent(), this.icon != null ? this.icon.getIconHeight() : 0) + 2;
        int n2 = n;
        this.preferredSize = new Dimension(this.xtext + n, this.hc);
        this.hc = this.icon != null ? this.hc - (this.icon.getIconHeight() - fontMetrics.getDescent()) / 2 : this.hc;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void layout() {
    }
}

