/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoScroll {
    Component comp;
    Insets insets;
    Insets scrollUnits;

    public AutoScroll(Component component, Insets insets) {
        this(component, insets, insets);
    }

    public AutoScroll(Component component, Insets insets, Insets insets2) {
        this.comp = component;
        this.insets = insets;
        this.scrollUnits = insets2;
    }

    public void autoscroll(Point point) {
        JViewport jViewport = this.getViewport();
        if (jViewport == null) {
            return;
        }
        Point point2 = jViewport.getViewPosition();
        int n = jViewport.getExtentSize().height;
        int n2 = jViewport.getExtentSize().width;
        if (point.y - point2.y < this.insets.top) {
            jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.scrollUnits.top, 0)));
        } else if (point2.y + n - point.y < this.insets.bottom) {
            jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.scrollUnits.bottom, this.comp.getHeight() - n)));
        } else if (point.x - point2.x < this.insets.left) {
            jViewport.setViewPosition(new Point(Math.max(point2.x - this.scrollUnits.left, 0), point2.y));
        } else if (point2.x + n2 - point.x < this.insets.right) {
            jViewport.setViewPosition(new Point(Math.min(point2.x + this.scrollUnits.right, this.comp.getWidth() - n2), point2.y));
        }
    }

    JViewport getViewport() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.comp);
    }
}

