/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable.action;

import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.ModelStateListener;
import java.util.ArrayList;
import javax.swing.Action;

public class BasicActionModel
extends ArrayList
implements ActionModel {
    private ArrayList listeners = null;

    public static ActionModel getInstance(Action action) {
        return BasicActionModel.getInstance(new Action[]{action});
    }

    public static ActionModel getInstance(Action[] actionArray) {
        return new BasicActionModel(actionArray);
    }

    public BasicActionModel() {
    }

    public BasicActionModel(Action[] actionArray) {
        if (actionArray == null) {
            throw new RuntimeException("Null actions ? ");
        }
        for (int i = actionArray.length - 1; i >= 0; --i) {
            this.addAction(actionArray[i]);
        }
    }

    public Action getActionByClass(Class clazz) {
        for (int i = 0; i < this.size(); ++i) {
            Object e = this.get(i);
            if (e.getClass() != clazz) continue;
            return (Action)e;
        }
        return null;
    }

    public Action getAction(int n) {
        return (Action)this.get(n);
    }

    public int getActionCount() {
        return this.size();
    }

    public void addAction(Action action) {
        this.add(action);
        this.fireStateChanged();
    }

    public void addAction(Action action, int n) {
        this.add(n, action);
        this.fireStateChanged();
    }

    public void removeAction(Action action) {
        this.remove(action);
        this.fireStateChanged();
    }

    public void removeAll() {
        super.removeAll(this);
        this.fireStateChanged();
    }

    public void addModelStateListener(ModelStateListener modelStateListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(modelStateListener);
    }

    public void removeModelStateListener(ModelStateListener modelStateListener) {
        if (this.listeners != null) {
            this.listeners.remove(modelStateListener);
        }
    }

    private void fireStateChanged() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ModelStateListener modelStateListener = (ModelStateListener)this.listeners.get(i);
                modelStateListener.modelModified(this);
            }
        }
    }

    public boolean isSeparator(int n) {
        return this.getAction(n) == SEPARATOR;
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.get(i);
        }
        string = string + "]";
        return string;
    }
}

