/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.JDock;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;

class DockableLayout
implements LayoutManager2 {
    private LayoutManager2 ref;
    private JDock doc;
    JComponent maximizedComponent = null;
    HashMap htComponentConstraints = null;
    HashMap htConstraintsResize = null;
    HashMap htCompComp = null;
    int borderX = 5;
    int borderY = 5;
    private HashMap htBoundComponent = null;

    public DockableLayout(JDock jDock, LayoutManager2 layoutManager2) {
        this.doc = jDock;
        this.ref = layoutManager2;
    }

    void dispose() {
        this.doc = null;
        this.removeContraints();
    }

    public void setMaximizedComponent(JComponent jComponent) {
        this.maximizedComponent = jComponent;
    }

    public boolean hasMaximizedComponent() {
        return this.maximizedComponent != null;
    }

    Object getKeyForValue(Object object, HashMap hashMap) {
        for (Object k : hashMap.keySet()) {
            Object v = hashMap.get(k);
            if (v != object) continue;
            return k;
        }
        return null;
    }

    void swap(Component component, Component component2) {
        if (this.htCompComp == null) {
            this.htCompComp = new HashMap();
        }
        Component component3 = (Component)this.htBoundComponent.get(component.getBounds());
        Component component4 = (Component)this.htBoundComponent.get(component2.getBounds());
        Object object = this.getKeyForValue(component3, this.htCompComp);
        Object object2 = this.getKeyForValue(component4, this.htCompComp);
        if (object != null) {
            this.htCompComp.remove(object);
        }
        if (object2 != null) {
            this.htCompComp.remove(object2);
        }
        this.htCompComp.put(component, component4);
        this.htCompComp.put(component2, component3);
    }

    boolean isConstraintsKnown(Object object) {
        if (this.htComponentConstraints == null) {
            return false;
        }
        for (Object v : this.htComponentConstraints.values()) {
            if (v != object) continue;
            return true;
        }
        return false;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null && this.htComponentConstraints != null) {
            object = this.htComponentConstraints.get(component);
        }
        this.ref.addLayoutComponent(component, object);
        if (this.htComponentConstraints == null) {
            this.htComponentConstraints = new HashMap();
        }
        this.htComponentConstraints.put(component, object);
    }

    public void removeLayoutComponent(Component component) {
        this.ref.removeLayoutComponent(component);
        if (this.htCompComp != null) {
            Component component2;
            Object object = this.getKeyForValue(component, this.htCompComp);
            if (object != null) {
                this.htCompComp.remove(object);
            }
            if ((component2 = (Component)this.htCompComp.get(component)) != null) {
                this.htCompComp.remove(component2);
            }
            this.htCompComp.remove(component);
        }
    }

    void disposeComponent(Component component) {
        this.resetConstraintResizeForHiddenComponent(component);
        this.removeLayoutComponent(component);
        Object v = this.htComponentConstraints.get(component);
        this.htComponentConstraints.remove(component);
        if (this.htConstraintsResize != null) {
            this.htConstraintsResize.remove(v);
        }
        if (this.htCompComp != null) {
            this.htCompComp.remove(component);
            Object object = this.getKeyForValue(component, this.htCompComp);
            if (object != null) {
                this.htCompComp.remove(object);
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.ref.maximumLayoutSize(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return this.ref.getLayoutAlignmentX(container);
    }

    public float getLayoutAlignmentY(Container container) {
        return this.ref.getLayoutAlignmentY(container);
    }

    public void invalidateLayout(Container container) {
        this.ref.invalidateLayout(container);
    }

    public void addLayoutComponent(String string, Component component) {
        this.ref.addLayoutComponent(string, component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.ref.preferredLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.ref.minimumLayoutSize(container);
    }

    void removeContraints() {
        this.htComponentConstraints = new HashMap();
        this.htConstraintsResize = new HashMap();
        this.htCompComp = new HashMap();
        this.htBoundComponent = new HashMap();
    }

    private void applyResize(Component component, int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Object v = this.htComponentConstraints.get(component);
        if (v == null) {
            throw new RuntimeException("Try to resize an unknown component");
        }
        if (this.htConstraintsResize == null) {
            this.htConstraintsResize = new HashMap();
        }
        if ((rectangle = (Rectangle)this.htConstraintsResize.get(v)) != null) {
            rectangle.width += n3;
            rectangle.height += n4;
            rectangle.x += n;
            rectangle.y += n2;
        } else {
            Rectangle rectangle2;
            rectangle = rectangle2 = new Rectangle(n, n2, n3, n4);
            this.htConstraintsResize.put(v, rectangle);
        }
    }

    void resize(ArrayList arrayList, int n, int n2, int n3, int n4) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Component component = (Component)arrayList.get(i);
            if (this.htCompComp != null) {
                if (this.htCompComp.containsKey(component)) {
                    component = (Component)this.htCompComp.get(component);
                } else if (this.htCompComp.containsValue(component)) {
                    for (Component component2 : this.htCompComp.keySet()) {
                        Component component3 = (Component)this.htCompComp.get(component2);
                        if (component3 != component) continue;
                        component = component2;
                        break;
                    }
                }
            }
            this.applyResize(component, n, n2, n3, n4);
        }
    }

    private void maximizedLayout(Container container) {
        Rectangle rectangle = container.getBounds();
        rectangle.x += this.borderX;
        rectangle.y = this.borderY;
        rectangle.width -= 2 * this.borderX;
        rectangle.height -= 2 * this.borderY;
        this.maximizedComponent.setBounds(rectangle);
        this.maximizedComponent.invalidate();
        this.maximizedComponent.validate();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component == this.maximizedComponent) continue;
            component.setBounds(rectangle2);
        }
    }

    public void layoutContainer(Container container) {
        Component component;
        int n;
        if (this.maximizedComponent != null) {
            this.maximizedLayout(container);
            return;
        }
        this.ref.layoutContainer(container);
        if (this.htComponentConstraints == null) {
            return;
        }
        this.htBoundComponent = new HashMap();
        HashMap<Component, Rectangle> hashMap = new HashMap<Component, Rectangle>();
        for (n = 0; n < container.getComponentCount(); ++n) {
            Rectangle rectangle;
            component = container.getComponent(n);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Object v = this.htComponentConstraints.get(component);
            boolean bl = false;
            if (this.htConstraintsResize != null && (rectangle = (Rectangle)this.htConstraintsResize.get(v)) != null) {
                n2 = rectangle.width;
                n3 = rectangle.height;
                n4 = rectangle.x;
                n5 = rectangle.y;
                bl = true;
            }
            int n6 = component.getWidth() - this.borderX + n2;
            int n7 = component.getHeight() - this.borderY + n3;
            int n8 = component.getX() + n4;
            int n9 = component.getY() + n5;
            Rectangle rectangle2 = new Rectangle(n8, n9, n6, n7);
            component.setBounds(rectangle2);
            hashMap.put(component, rectangle2);
            this.htBoundComponent.put(rectangle2, component);
            if (this.htCompComp != null && this.htCompComp.containsKey(component)) continue;
            component.invalidate();
            component.validate();
        }
        if (this.htCompComp != null) {
            for (n = 0; n < container.getComponentCount(); ++n) {
                component = container.getComponent(n);
                Component component2 = (Component)this.htCompComp.get(component);
                if (component2 == null) continue;
                Rectangle rectangle = (Rectangle)hashMap.get(component2);
                component.setBounds(rectangle);
                component.invalidate();
                component.validate();
            }
        }
    }

    private void resetConstraintResizeForOtherComponentInY(int n, Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Rectangle rectangle;
            Object v;
            Component component2 = container.getComponent(i);
            if (component2 == component) continue;
            if (component2.getBounds().contains(component2.getX() + 1, component.getY() - 15)) {
                v = this.htComponentConstraints.get(component2);
                if (v == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
                rectangle.height -= n;
                continue;
            }
            if (component2.getY() != component.getY() || (v = this.htComponentConstraints.get(component2)) == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
            rectangle.y = 0;
        }
    }

    private void resetConstraintResizeForOtherComponentInHeight(int n, Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Rectangle rectangle;
            Object v;
            Component component2 = container.getComponent(i);
            if (component2 == component) continue;
            if (component2.getBounds().contains(component2.getX() + 1, component.getY() + component.getHeight() + 15)) {
                v = this.htComponentConstraints.get(component2);
                if (v == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
                rectangle.y -= n;
                rectangle.height += n;
                continue;
            }
            if (component2.getY() != component.getY() || (v = this.htComponentConstraints.get(component2)) == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
            rectangle.height = 0;
        }
    }

    private void resetConstraintResizeForOtherComponentInX(int n, Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Rectangle rectangle;
            Object v;
            Component component2 = container.getComponent(i);
            if (component2 == component) continue;
            if (component2.getBounds().contains(component.getX() - 15, component.getY())) {
                v = this.htComponentConstraints.get(component2);
                if (v == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
                rectangle.width -= n;
                continue;
            }
            if (component2.getX() != component.getX() || (v = this.htComponentConstraints.get(component2)) == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
            rectangle.x = 0;
        }
    }

    private void resetConstraintResizeForOtherComponentInWidth(int n, Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Rectangle rectangle;
            Object v;
            Component component2 = container.getComponent(i);
            if (component2 == component) continue;
            if (component2.getBounds().contains(component.getX() + component.getWidth() + 15, component2.getY())) {
                v = this.htComponentConstraints.get(component2);
                if (v == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
                rectangle.x -= n;
                rectangle.width += n;
                continue;
            }
            if (component2.getX() != component.getX() || (v = this.htComponentConstraints.get(component2)) == null || (rectangle = (Rectangle)this.htConstraintsResize.get(v)) == null) continue;
            rectangle.width = 0;
        }
    }

    void resetConstraintResizeForHiddenComponent(Component component) {
        Rectangle rectangle;
        this.debugConstraints("before", component.getParent());
        Object v = this.htComponentConstraints.get(component);
        if (this.htConstraintsResize != null && (rectangle = (Rectangle)this.htConstraintsResize.get(v)) != null) {
            Container container = component.getParent();
            if (rectangle.y != 0) {
                this.resetConstraintResizeForOtherComponentInY(rectangle.y, container, component);
                rectangle.height += rectangle.y;
                rectangle.y = 0;
                this.debugConstraints("y", component.getParent());
            }
            if (rectangle.height != 0) {
                this.resetConstraintResizeForOtherComponentInHeight(rectangle.height, container, component);
                this.debugConstraints("height", component.getParent());
            }
            if (rectangle.x != 0) {
                this.resetConstraintResizeForOtherComponentInX(rectangle.x, container, component);
                rectangle.width += rectangle.x;
                this.debugConstraints("x", component.getParent());
            }
            if (rectangle.width != 0) {
                this.resetConstraintResizeForOtherComponentInWidth(rectangle.width, container, component);
                this.debugConstraints("width", component.getParent());
            }
            this.htConstraintsResize.remove(v);
        }
        this.debugConstraints("all", component.getParent());
    }

    private void debugConstraints(String string, Container container) {
    }
}

