/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.LineSelectionListener;
import com.japisoft.editix.ui.xslt.debug.DebugContext;
import com.japisoft.editix.ui.xslt.debug.DebugElement;
import com.japisoft.editix.ui.xslt.debug.DebugVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class XSLTDebugContainer
extends JPanel
implements ListSelectionListener {
    private LineSelectionListener container;
    JTabbedPane tp = new JTabbedPane(3);
    private JTable callStack;
    private JTable nodeSet;
    private JTable variables;
    private JTable parameters;
    TableCellRenderer elementRenderer;

    public XSLTDebugContainer(LineSelectionListener lineSelectionListener) {
        this.initUI();
        this.container = lineSelectionListener;
    }

    public void dispose() {
        this.container = null;
        this.updateTableForNode(this.callStack, null);
        this.updateTableForNode(this.nodeSet, null);
    }

    public void updateDebugContext(DebugContext debugContext) {
        this.updateTableForNode(this.callStack, debugContext.callStack);
        this.updateTableForNode(this.nodeSet, debugContext.nodeSet);
        this.updateTableForVariable(this.variables, debugContext.variable);
        this.updateTableForVariable(this.parameters, debugContext.parameter);
        if (this.tp.getSelectedIndex() == 0) {
            this.unLinkListeners();
            this.callStack.getSelectionModel().setSelectionInterval(this.callStack.getRowCount() - 1, this.callStack.getRowCount() - 1);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JViewport jViewport = (JViewport)XSLTDebugContainer.this.callStack.getParent();
                    Rectangle rectangle = XSLTDebugContainer.this.callStack.getCellRect(XSLTDebugContainer.this.callStack.getRowCount() - 1, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.translate(-point.x, -point.y);
                    jViewport.scrollRectToVisible(rectangle);
                }
            });
            this.linkListeners();
        }
        JTable[] jTableArray = new JTable[]{this.callStack, this.nodeSet, this.variables, this.parameters};
        for (int i = 0; i < jTableArray.length; ++i) {
            this.tp.setEnabledAt(i, jTableArray[i].getRowCount() > 0);
        }
    }

    private void initUI() {
        this.tp.addTab("Call Stack", this.getCallStack());
        this.tp.addTab("XPath Context", this.getNodeSet());
        this.tp.addTab("Variables", this.getVariables());
        this.tp.addTab("Parameters", this.getParameters());
        this.setLayout(new BorderLayout());
        this.add(this.tp);
    }

    public void addNotify() {
        super.addNotify();
        this.linkListeners();
    }

    private void linkListeners() {
        this.callStack.getSelectionModel().addListSelectionListener(this);
        this.nodeSet.getSelectionModel().addListSelectionListener(this);
        this.variables.getSelectionModel().addListSelectionListener(this);
        this.parameters.getSelectionModel().addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.unLinkListeners();
    }

    private void unLinkListeners() {
        this.callStack.getSelectionModel().removeListSelectionListener(this);
        this.nodeSet.getSelectionModel().removeListSelectionListener(this);
        this.variables.getSelectionModel().removeListSelectionListener(this);
        this.parameters.getSelectionModel().removeListSelectionListener(this);
    }

    private JTable getCommonTable() {
        JTable jTable = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public boolean isEditing() {
                return false;
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                return XSLTDebugContainer.this.elementRenderer;
            }
        };
        jTable.setSelectionMode(0);
        return jTable;
    }

    private JTable prepareElementTable() {
        if (this.elementRenderer == null) {
            this.elementRenderer = new ElementRenderer();
        }
        JTable jTable = this.getCommonTable();
        this.updateTableForNode(jTable, null);
        return jTable;
    }

    private JScrollPane getCallStack() {
        this.callStack = this.prepareElementTable();
        return new JScrollPane(this.callStack);
    }

    private JScrollPane getNodeSet() {
        this.nodeSet = this.prepareElementTable();
        return new JScrollPane(this.nodeSet);
    }

    private JScrollPane getVariables() {
        JTable jTable = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.getSelectionModel().setSelectionMode(0);
        this.variables = jTable;
        this.updateTableForVariable(this.variables, null);
        return new JScrollPane(jTable);
    }

    private JScrollPane getParameters() {
        JTable jTable = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.getSelectionModel().setSelectionMode(0);
        this.parameters = jTable;
        this.updateTableForVariable(this.parameters, null);
        return new JScrollPane(jTable);
    }

    private void updateTableForVariable(JTable jTable, ArrayList arrayList) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Name", "Type", "Value"}, 0);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DebugVariable debugVariable = (DebugVariable)arrayList.get(i);
                Vector<Object> vector = new Vector<Object>();
                vector.add(debugVariable.name);
                vector.add(debugVariable.type);
                if (debugVariable.value == null) {
                    vector.add("[NO VALUE]");
                } else {
                    vector.add(debugVariable.value);
                }
                vector.add(new Integer(debugVariable.line));
                defaultTableModel.getDataVector().addElement(vector);
            }
        }
        jTable.setModel(defaultTableModel);
    }

    private void updateTableForNode(JTable jTable, ArrayList arrayList) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Nodes"}, 0);
        if (arrayList != null && arrayList.size() > 0) {
            DebugElement debugElement = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                defaultTableModel.addRow(new Object[]{arrayList.get(i)});
                if (!(arrayList.get(i) instanceof DebugElement) || ((DebugElement)arrayList.get((int)i)).resultElement) continue;
                debugElement = (DebugElement)arrayList.get(i);
            }
            if (jTable == this.nodeSet && debugElement != null) {
                this.container.showSourceLine(debugElement.line);
            }
        }
        jTable.setModel(defaultTableModel);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        Object object = listSelectionEvent.getSource();
        JTable jTable = null;
        jTable = this.callStack.getSelectionModel() == object ? this.callStack : (this.nodeSet.getSelectionModel() == object ? this.nodeSet : (this.variables.getSelectionModel() == object ? this.variables : this.parameters));
        if (jTable == null) {
            System.err.println("No table found ???");
            return;
        }
        TableModel tableModel = jTable.getModel();
        int n2 = jTable.getSelectedRow();
        if (n2 == -1) {
            return;
        }
        if ((jTable == this.variables || jTable == this.parameters) && (n = ((Integer)tableModel.getValueAt(n2, 3)).intValue()) > 0) {
            this.container.showXSLTLine(null, n);
            return;
        }
        DebugElement debugElement = (DebugElement)tableModel.getValueAt(n2, 0);
        Object var7_8 = null;
        if (jTable == this.callStack) {
            this.container.showXSLTLine(debugElement.uri, debugElement.line);
        } else if (jTable == this.nodeSet) {
            this.container.showSourceLine(debugElement.line);
        }
    }

    class ElementRenderer
    implements TableCellRenderer {
        private JLabel labelResult = new JLabel();
        private ImageIcon icon1 = new ImageIcon(ClassLoader.getSystemResource("images/media_stop.png"));
        private ImageIcon icon2 = new ImageIcon(ClassLoader.getSystemResource("images/media_stop_red.png"));

        public ElementRenderer() {
            this.labelResult.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.labelResult.setForeground(jTable.getSelectionForeground());
                this.labelResult.setBackground(jTable.getSelectionBackground());
            } else {
                this.labelResult.setForeground(jTable.getForeground());
                this.labelResult.setBackground(jTable.getBackground());
            }
            DebugElement debugElement = (DebugElement)object;
            if (debugElement.resultElement) {
                this.labelResult.setIcon(this.icon1);
            } else {
                this.labelResult.setIcon(this.icon2);
            }
            this.labelResult.setText(debugElement.toString());
            return this.labelResult;
        }
    }
}

