/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view.designer;

import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.designer.ColorFactory;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponent;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponentListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XSDAbstractComponentImpl
extends JComponent
implements MouseListener,
XSDComponent,
MouseMotionListener {
    protected Element e;
    protected boolean selected = false;
    protected boolean opened = false;
    protected boolean paintElementName = true;
    protected boolean paintName = true;
    private static final Stroke OPT_ELE_BORDER = new BasicStroke(1.0f, 0, 0, 2.0f, new float[]{2.0f}, 0.0f);
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    static final ImageIcon CLOSE_ICON = new ImageIcon(XSDAbstractComponentImpl.class.getResource("box_closed.png"));
    public static final ImageIcon OPEN_ICON = new ImageIcon(XSDAbstractComponentImpl.class.getResource("box.png"));
    private XSDComponentListener listener;
    protected boolean hasOpenIcon = true;
    protected Stroke borderStyle;
    private static Font typeFont = new Font("arial", 2, 8);
    private static Font nameFont = new Font("arial", 1, 10);
    private static Color SELECTED_COLOR = ColorFactory.getSelectedBackgroundColor(null);
    private Shape rCache = null;
    protected Dimension cachedPreferredSize = null;
    private static XSDAbstractComponentImpl currentDragComponent = null;
    private static XSDAbstractComponentImpl currentDropComponent = null;
    private static boolean acceptedImport = false;

    public XSDAbstractComponentImpl() {
        this.setTransferHandler(new DragDropImpl());
    }

    public void setElement(Element element) {
        this.e = element;
        this.setBackground(ColorFactory.getBackgroundColor(this.getLocalName()));
    }

    public Element getElement() {
        return this.e;
    }

    public void dispose() {
        this.e.setUserData("ui", null, null);
        this.e = null;
        this.listener = null;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            XSDComponent xSDComponent = (XSDComponent)((Object)this.getComponent(i));
            xSDComponent.dispose();
        }
    }

    public JComponent getView() {
        return this;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public void setOpened(boolean bl) {
        this.opened = bl;
        this.e.setUserData("opened", new Boolean(bl), null);
        this.repaint();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setComponentListener(XSDComponentListener xSDComponentListener) {
        this.listener = xSDComponentListener;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth() - (this.hasOpenIcon ? OPEN_ICON.getIconWidth() : 0), this.getHeight());
        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (mouseEvent.getClickCount() > 1) {
                this.listener.goInto(this);
            } else {
                this.listener.select(this);
            }
        } else {
            rectangle = new Rectangle(this.getWidth() - OPEN_ICON.getIconWidth(), 0, OPEN_ICON.getIconWidth(), this.getHeight());
            if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.listener.openClose(this);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mayBePopup(mouseEvent);
    }

    private void mayBePopup(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (mouseEvent.isPopupTrigger() && (rectangle = new Rectangle(0, 0, this.getWidth() - OPEN_ICON.getIconWidth(), this.getHeight())).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.listener.popup(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mayBePopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setToolTipText(XSDAbstractComponentImpl.getToolTip(this.e, "Right click for adding an element<br>Double click for going into the definition"));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        currentDragComponent = this;
        this.getTransferHandler().exportAsDrag(this, mouseEvent, 2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static String getToolTip(Element element, String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        stringBuffer.append("<b>").append(element.getLocalName()).append("</b>");
        String string3 = null;
        if (element.hasAttribute("name")) {
            string3 = element.getAttribute("name");
        } else if (element.hasAttribute("ref")) {
            string3 = element.getAttribute("ref");
        }
        if (string3 != null) {
            stringBuffer.append("<i> ").append(string3);
            if (element.hasAttribute("type")) {
                stringBuffer.append(" (" + element.getAttribute("type") + ")");
            }
            stringBuffer.append("</i>");
        }
        if ((string2 = SchemaHelper.getDocumentation(element)) != null) {
            stringBuffer.append("<div style='width:400px;color:green'>");
            stringBuffer.append(string2);
            stringBuffer.append("</div>");
        }
        if (string != null) {
            stringBuffer.append("<div style='color:gray'>");
            stringBuffer.append(string);
            stringBuffer.append("</div>");
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected boolean isOptional() {
        return "0".equals(this.e.getAttribute("minOccurs")) || "optional".equals(this.e.getAttribute("use"));
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = OPEN_ICON.getIconWidth();
        int n2 = OPEN_ICON.getIconHeight();
        if (!this.hasOpenIcon) {
            n = 0;
            n2 = 0;
        }
        int n3 = 1;
        int n4 = 1;
        if (this.rCache == null || this.rCache.getBounds().width != this.getWidth() - n - 2 || this.rCache.getBounds().height != this.getHeight() - 2) {
            this.rCache = this.createBorderShape();
        }
        if (this.selected) {
            graphics.setColor(SELECTED_COLOR);
        } else {
            graphics.setColor(this.getBackground());
        }
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, graphics2D.getColor(), this.getWidth(), this.getHeight(), Color.WHITE, false));
        graphics2D.fill(this.rCache);
        graphics2D.setPaint(paint);
        if (this.hasOpenIcon()) {
            Image image = CLOSE_ICON.getImage();
            if (this.opened) {
                image = OPEN_ICON.getImage();
            }
            graphics.drawImage(image, this.getWidth() - OPEN_ICON.getIconWidth(), this.getHeight() / 2 - OPEN_ICON.getIconHeight() / 2, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.BLUE);
        } else {
            graphics2D.setColor(Color.GRAY);
        }
        if (this.borderStyle != null) {
            graphics2D.setStroke(this.borderStyle);
        } else if (this.isOptional()) {
            graphics2D.setStroke(OPT_ELE_BORDER);
        }
        graphics2D.draw(this.rCache);
        this.paintSpecialContent(graphics2D);
        ++n4;
        if (this.borderStyle != null) {
            graphics2D.setStroke(DEFAULT_STROKE);
        }
        if (this.paintElementName) {
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.setFont(typeFont);
            graphics2D.drawString(this.getElementName(), n4 + 1, n3 + this.getFontMetrics(typeFont).getAscent() + 1);
        }
        if (this.paintName && this.isNameVisible()) {
            if (this.selected) {
                graphics2D.setColor(ColorFactory.getSelectedForegroundColor(this.getElementName()));
            } else {
                graphics2D.setColor(ColorFactory.getForegroundColor(this.getElementName()));
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(nameFont);
            graphics2D.drawString(this.getName(), n4 + 1, n3 += (this.getHeight() - this.getFontMetrics(typeFont).getHeight()) / 2 + this.getFontMetrics(nameFont).getAscent() - 2);
        }
        if (this.e.hasAttribute("ref")) {
            graphics2D.setColor(Color.GRAY);
            graphics2D.fillPolygon(new int[]{this.getWidth() - n - 1, this.getWidth() - n - 1, this.getWidth() - 5 - n - 1}, new int[]{this.getHeight() - 5 - 1, this.getHeight() - 1, this.getHeight() - 1}, 3);
        }
    }

    protected boolean isNameVisible() {
        return true;
    }

    protected void paintSpecialContent(Graphics2D graphics2D) {
    }

    private boolean hasOpenIcon() {
        if (this.hasOpenIcon && this.e.hasChildNodes()) {
            NodeList nodeList = this.e.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
                if ("simpleType".equals(node.getLocalName())) {
                    return false;
                }
                if ("annotation".equals(node.getLocalName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected Shape createBorderShape() {
        int n = OPEN_ICON.getIconWidth();
        int n2 = OPEN_ICON.getIconHeight();
        int n3 = 1;
        int n4 = 1;
        if (!this.hasOpenIcon) {
            n = 0;
            n2 = 0;
        }
        return new Rectangle(n4, n3, this.getWidth() - n - 2, this.getHeight() - 2);
    }

    public Rectangle getVisibleBounds() {
        int n = OPEN_ICON.getIconWidth();
        int n2 = OPEN_ICON.getIconHeight();
        int n3 = 1;
        int n4 = 1;
        return new Rectangle(n3, n4, this.getWidth() - n - 2, this.getHeight());
    }

    public String getElementName() {
        return this.e.getLocalName();
    }

    public String getLocalName() {
        return this.e.getLocalName();
    }

    public String getName() {
        if (this.e.hasAttribute("name")) {
            return this.e.getAttribute("name");
        }
        if (this.e.hasAttribute("ref")) {
            return this.e.getAttribute("ref");
        }
        return "";
    }

    public void updateUIContentCache() {
        this.cachedPreferredSize = null;
    }

    public Dimension getPreferredSize() {
        return this.getNameSize();
    }

    protected Dimension getNameSize() {
        if (this.cachedPreferredSize != null) {
            return this.cachedPreferredSize;
        }
        int n = 0;
        int n2 = 0;
        if (this.hasOpenIcon) {
            n2 += CLOSE_ICON.getIconHeight();
        }
        if (this.hasOpenIcon) {
            n += OPEN_ICON.getIconWidth();
        }
        FontMetrics fontMetrics = this.getFontMetrics(typeFont);
        n2 = Math.max(n2, fontMetrics.getHeight());
        String string = this.getName();
        if (string != null) {
            FontMetrics fontMetrics2 = this.getFontMetrics(nameFont);
            n += Math.max(fontMetrics2.stringWidth(string), fontMetrics.stringWidth(this.e.getLocalName()));
        } else {
            n += fontMetrics.stringWidth(this.e.getLocalName());
        }
        this.cachedPreferredSize = new Dimension(n + 5, n2 + 10);
        return this.cachedPreferredSize;
    }

    public void remove(boolean bl) {
        NodeList nodeList = this.e.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                XSDComponent xSDComponent;
                if (!(nodeList.item(i) instanceof Element) || (xSDComponent = (XSDComponent)(element = (Element)nodeList.item(i)).getUserData("ui")) == null) continue;
                xSDComponent.remove(bl);
            }
        }
        Container container = this.getParent();
        container.remove(this);
        container.invalidate();
        if (bl) {
            container.validate();
            container.repaint();
        }
        this.dispose();
    }

    class DragDropImpl
    extends TransferHandler {
        DragDropImpl() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            acceptedImport = this.testImport(jComponent);
            if (acceptedImport) {
                currentDropComponent = (XSDAbstractComponentImpl)jComponent;
            }
            return acceptedImport;
        }

        private boolean testImport(JComponent jComponent) {
            if (currentDragComponent != null && jComponent instanceof XSDAbstractComponentImpl) {
                Element element;
                XSDAbstractComponentImpl xSDAbstractComponentImpl = (XSDAbstractComponentImpl)jComponent;
                Element element2 = currentDragComponent.getElement();
                if (element2 == (element = xSDAbstractComponentImpl.getElement())) {
                    return true;
                }
                while (element != null && element.getParentNode() instanceof Element) {
                    if ((element = (Element)element.getParentNode()) != element2) continue;
                    return false;
                }
                element = xSDAbstractComponentImpl.getElement();
                if (SchemaHelper.canHaveThisChild(element, element2)) {
                    return true;
                }
                return SchemaHelper.canHaveThisChild((Element)element.getParentNode(), element2);
            }
            return false;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            return new StringSelection(jComponent.getName());
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
            if (acceptedImport) {
                Serializable serializable;
                JPopupMenu jPopupMenu = new JPopupMenu();
                Element element = currentDropComponent.getElement();
                Element element2 = currentDragComponent.getElement();
                if (element2 == element) {
                    return;
                }
                if (SchemaHelper.canHaveThisChild((Element)element.getParentNode(), element2)) {
                    serializable = new JMenuItem(new AddBeforeAction(element2, element));
                    jPopupMenu.add((JMenuItem)serializable);
                    serializable = new JMenuItem(new AddAfterAction(element2, element));
                    jPopupMenu.add((JMenuItem)serializable);
                }
                if (SchemaHelper.canHaveThisChild(element, element2)) {
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.addSeparator();
                    }
                    serializable = new AddChildAction(element2, element);
                    if (jPopupMenu.getComponentCount() == 0) {
                        ((AddChildAction)serializable).actionPerformed(null);
                    } else {
                        JMenuItem jMenuItem = new JMenuItem((Action)((Object)serializable));
                        jPopupMenu.add(jMenuItem);
                    }
                }
                if (jPopupMenu.getComponentCount() > 0) {
                    jPopupMenu.show(currentDropComponent, 0, 0);
                }
            }
            currentDragComponent = null;
            currentDropComponent = null;
            acceptedImport = false;
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            return super.importData(jComponent, transferable);
        }
    }

    class AddAfterAction
    extends AbstractAction {
        private Element dragElement = null;
        private Element dropElement = null;

        AddAfterAction(Element element, Element element2) {
            this.putValue("Name", "Add after this node");
            this.dragElement = element;
            this.dropElement = element2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XSDAbstractComponentImpl.this.listener.moveAfter((XSDComponent)this.dragElement.getUserData("ui"), (XSDComponent)this.dropElement.getUserData("ui"));
            this.dragElement = null;
            this.dropElement = null;
        }
    }

    class AddBeforeAction
    extends AbstractAction {
        private Element dragElement = null;
        private Element dropElement = null;

        AddBeforeAction(Element element, Element element2) {
            this.putValue("Name", "Add before this node");
            this.dragElement = element;
            this.dropElement = element2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XSDAbstractComponentImpl.this.listener.moveBefore((XSDComponent)this.dragElement.getUserData("ui"), (XSDComponent)this.dropElement.getUserData("ui"));
            this.dragElement = null;
            this.dropElement = null;
        }
    }

    class AddChildAction
    extends AbstractAction {
        private Element dragElement = null;
        private Element dropElement = null;

        AddChildAction(Element element, Element element2) {
            this.putValue("Name", "Add as a child");
            this.dragElement = element;
            this.dropElement = element2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XSDAbstractComponentImpl.this.listener.moveInto((XSDComponent)this.dragElement.getUserData("ui"), (XSDComponent)this.dropElement.getUserData("ui"));
            this.dragElement = null;
            this.dropElement = null;
        }
    }
}

