/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.toolkit;

import com.japisoft.editix.ui.xsd.toolkit.XSDAttribute;
import com.japisoft.xmlpad.toolkit.XMLFileData;
import com.japisoft.xmlpad.toolkit.XMLToolkit;
import java.io.File;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class SchemaHelper {
    public static String[] FACETS = new String[]{"enumeration", "fractionDigits", "length", "minExclusive", "minInclusive", "minLength", "maxExclusive", "maxInclusive", "maxLength", "pattern", "totalDigits", "whiteSpace"};
    public static String[] PTYPES = new String[]{"string", "boolean", "float", "double", "decimal", "duration", "dateTime", "time", "date", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth", "hexBinary", "base64Binary", "anyURI", "QName", "NOTATION", "normalizedString", "token", "language", "IDREFS", "ENTITIES", "NMTOKEN", "NMTOKENS", "Name", "NCName", "ID", "IDREF", "ENTITY", "integer", "nonPositiveInteger", "negativeInteger", "long", "int", "short", "byte", "nonNegativeInteger", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger"};

    public static XSDAttribute[] getAttributesForElement(String string, boolean bl) {
        if ("notation".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("public", null, true), new XSDAttribute("system", null, true)};
        }
        if ("element".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("abstract", 1, null, false), new XSDAttribute("block", new String[]{"#all", "extension", "restriction", "substitution"}, true), new XSDAttribute("default", null, true), new XSDAttribute("final", new String[]{"#all"}, true), new XSDAttribute("fixed", null, true), new XSDAttribute("form", new String[]{"qualified", "unqualified"}, false), new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"unbounded"}, true), new XSDAttribute("minOccurs", 2, new String[]{"1"}, true), new XSDAttribute("name", null, true), new XSDAttribute("nillable", 1, null, false), new XSDAttribute("ref", 3, null, true), new XSDAttribute("substitutionGroup", 3, null, true), new XSDAttribute("type (base)", 9, null, true)};
        }
        if ("complexType".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("abstract", 1, null, false), new XSDAttribute("block", new String[]{"#all", "extension", "restriction"}, true), new XSDAttribute("final", new String[]{"#all", "extension", "restriction"}, true), new XSDAttribute("id", null, true), new XSDAttribute("mixed", 1, null, false), new XSDAttribute("name", null, true)};
        }
        if ("simpleType".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("final", new String[]{"#all"}, true), new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("type (base)", 8, null, true)};
        }
        if ("attribute".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("default", null, true), new XSDAttribute("fixed", null, true), new XSDAttribute("form", new String[]{"qualified", "unqualified"}, false), new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", 5, null, true), new XSDAttribute("type (base)", 8, null, true), new XSDAttribute("use", new String[]{"optional", "prohibited", "required"}, false)};
        }
        if ("attributeGroup".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", 10, null, true)};
        }
        if ("complexContent".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("mixed", 1, null, false)};
        }
        if ("restriction".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("base", 9, null, true), new XSDAttribute("id", null, true)};
        }
        if ("extension".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("base", 9, null, true), new XSDAttribute("id", null, true)};
        }
        if ("anyAttribute".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("namespace", new String[]{"##any", "##other"}, true)};
        }
        if ("group".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"unbounded"}, true), new XSDAttribute("minOccurs", 2, new String[]{"1"}, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", 6, null, true)};
        }
        if ("all".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"1"}, false), new XSDAttribute("minOccurs", 2, new String[]{"0", "1"}, false)};
        }
        if ("choice".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"unbounded"}, true), new XSDAttribute("minOccurs", 2, new String[]{"1"}, true)};
        }
        if ("sequence".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"unbounded"}, true), new XSDAttribute("minOccurs", 2, new String[]{"1"}, true)};
        }
        if ("any".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("maxOccurs", 2, new String[]{"unbounded"}, true), new XSDAttribute("minOccurs", 2, new String[]{"1"}, true), new XSDAttribute("namespace", new String[]{"##any", "##other"}, true), new XSDAttribute("processContents", new String[]{"lax", "skip", "strict"}, false)};
        }
        if ("include".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("schemaLocation", 7, null, true)};
        }
        if ("redefine".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("schemaLocation", 7, null, true)};
        }
        if ("import".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("namespace", null, true), new XSDAttribute("schemaLocation", 7, null, true)};
        }
        if ("annotation".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true)};
        }
        if ("appinfo".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("source", null, true)};
        }
        if ("documentation".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("source", null, true), new XSDAttribute("xml:lang", null, true)};
        }
        if ("key".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", null, true), new XSDAttribute("xpathDefaultNamespace", new String[]{"##defaultNamespace", "##targetNamespace", "##local"}, true)};
        }
        if ("keyref".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", null, true), new XSDAttribute("refer", null, true), new XSDAttribute("xpathDefaultNamespace", new String[]{"##defaultNamespace", "##targetNamespace", "##local"}, true)};
        }
        if ("unique".equals(string)) {
            return new XSDAttribute[]{new XSDAttribute("id", null, true), new XSDAttribute("name", null, true), new XSDAttribute("ref", null, true), new XSDAttribute("xpathDefaultNamespace", new String[]{"##defaultNamespace", "##targetNamespace", "##local"}, true)};
        }
        return null;
    }

    public static String[] getChildrenForElement(Element element) {
        String string = element.getLocalName();
        if ("notation".equals(string)) {
            return new String[0];
        }
        if ("element".equals(string)) {
            if (SchemaHelper.hasChild(element, "complexType")) {
                return new String[]{"unique", "key", "keyref"};
            }
            if (!SchemaHelper.hasChild(element, "simpleType")) {
                return new String[]{"complexType", "unique", "key", "keyref"};
            }
        } else {
            if ("complexType".equals(string)) {
                if (SchemaHelper.hasChild(element, "simpleContent")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                if (SchemaHelper.hasChild(element, "complexContent")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                if (SchemaHelper.hasChild(element, "group")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                if (SchemaHelper.hasChild(element, "all")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                if (SchemaHelper.hasChild(element, "choice")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                if (SchemaHelper.hasChild(element, "sequence")) {
                    return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                }
                return new String[]{"simpleContent", "complexContent", "group", "all", "choice", "sequence", "attribute", "attributeGroup", "anyAttribute"};
            }
            if ("simpleType".equals(string)) {
                return new String[0];
            }
            if ("attribute".equals(string)) {
                return new String[0];
            }
            if ("attributeGroup".equals(string)) {
                return new String[]{"attribute", "attributeGroup", "anyAttribute"};
            }
            if ("complexContent".equals(string) || "simpleContent".equals(string)) {
                if (!SchemaHelper.hasChild(element, "restriction") && !SchemaHelper.hasChild(element, "extension")) {
                    return new String[]{"restriction", "extension"};
                }
            } else {
                if ("restriction".equals(string)) {
                    if (SchemaHelper.hasChild(element, "group") || SchemaHelper.hasChild(element, "all") || SchemaHelper.hasChild(element, "choice") || SchemaHelper.hasChild(element, "sequence")) {
                        return new String[]{"attribute", "attributeGroup", "anyAttribute"};
                    }
                    return new String[]{"group", "all", "choice", "sequence"};
                }
                if ("extension".equals(string)) {
                    return new String[]{"group", "all", "choice", "sequence", "attribute"};
                }
                if ("anyAttribute".equals(string)) {
                    return new String[0];
                }
                if ("group".equals(string)) {
                    if (!(SchemaHelper.hasChild(element, "all") || SchemaHelper.hasChild(element, "choice") || SchemaHelper.hasChild(element, "sequence"))) {
                        return new String[]{"all", "choice", "sequence"};
                    }
                } else {
                    if ("all".equals(string)) {
                        return new String[]{"element"};
                    }
                    if ("choice".equals(string)) {
                        return new String[]{"element", "group", "choice", "sequence", "any"};
                    }
                    if ("sequence".equals(string)) {
                        return new String[]{"element", "group", "choice", "sequence", "any"};
                    }
                    if ("any".equals(string)) {
                        return new String[0];
                    }
                    if ("include".equals(string)) {
                        return new String[0];
                    }
                    if ("redefine".equals(string)) {
                        return new String[0];
                    }
                }
            }
        }
        if ("import".equals(string)) {
            return new String[0];
        }
        if ("annotation".equals(string)) {
            return new String[0];
        }
        if ("appinfo".equals(string)) {
            return new String[0];
        }
        if ("documentation".equals(string)) {
            return new String[0];
        }
        return null;
    }

    public static void removeChildren(Element element) {
        while (element.getFirstChild() != null) {
            element.removeChild(element.getFirstChild());
        }
    }

    public static boolean hasChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !string.equals((element2 = (Element)nodeList.item(i)).getLocalName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChildrenExceptAnnotationAndText(Element element) {
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || "annotation".equals((element2 = (Element)node).getLocalName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getDocumentation(Element element) {
        Element element2;
        Element element3 = SchemaHelper.getChildAt(element, 0, new String[]{"annotation"});
        if (element3 != null && (element2 = SchemaHelper.getChildAt(element3, 0, new String[]{"documentation"})) != null) {
            return SchemaHelper.getTexts(element2);
        }
        return null;
    }

    public static boolean createNewAnnotation(Element element, String string) {
        Node node;
        NodeList nodeList = element.getChildNodes();
        Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            node = nodeList.item(i);
            if (node2 == null) {
                node2 = node;
            }
            if (!(node instanceof Element) || "annotation".equals((element2 = (Element)node).getLocalName())) continue;
            return false;
        }
        Element element3 = SchemaHelper.createTag(element, "annotation");
        node = SchemaHelper.createTag(element, "documentation");
        element3.appendChild(node);
        node.appendChild(element.getOwnerDocument().createTextNode(string));
        if (node2 != null) {
            element.insertBefore(element3, node2);
        } else {
            element.appendChild(element3);
        }
        return true;
    }

    public static void deleteUnionType(Element element, int n) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "union");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (element2.hasAttribute("memberTypes")) {
                String string = element2.getAttribute("memberTypes");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t", false);
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (n == 0) {
                        n = -1;
                        continue;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string2);
                    --n;
                }
                element2.setAttribute("memberTypes", stringBuffer.toString());
            } else {
                NodeList nodeList2 = element2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element3;
                    Node node = nodeList2.item(i);
                    if (!(node instanceof Element) || !"simpleType".equals((element3 = (Element)node).getLocalName())) continue;
                    if (n == 0) {
                        element2.removeChild(element3);
                        break;
                    }
                    --n;
                }
            }
        }
    }

    public static void updateUnion(Element element, int n, String string) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "union");
        if (nodeList.getLength() == 0) {
            Element element2 = element;
            SchemaHelper.removeChildren(element);
            if (!"simpleType".equals(element.getLocalName())) {
                element2 = SchemaHelper.createTag(element, "simpleType");
                element.appendChild(element2);
            }
            Element element3 = SchemaHelper.createTag(element, "union");
            element3.setAttribute("memberTypes", string);
            element2.appendChild(element3);
            if ("element".equals(element.getLocalName()) || "attribute".equals(element.getLocalName())) {
                element.removeAttribute("type");
            }
        } else {
            Element element4 = (Element)nodeList.item(0);
            if (element4.hasAttribute("memberTypes")) {
                String string2 = element4.getAttribute("memberTypes");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t", false);
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (n == 0) {
                        string3 = string;
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string3);
                    --n;
                }
                if (n == 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string);
                }
                element4.setAttribute("memberTypes", stringBuffer.toString());
            } else {
                Node node;
                NodeList nodeList2 = element4.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element5;
                    node = nodeList2.item(i);
                    if (!(node instanceof Element) || !"simpleType".equals((element5 = (Element)node).getLocalName())) continue;
                    if (n == 0) {
                        NodeList nodeList3 = element5.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction");
                        if (nodeList3.getLength() > 0) {
                            ((Element)nodeList3.item(0)).setAttribute("base", string);
                        }
                        n = -1;
                        break;
                    }
                    --n;
                }
                if (n == 0) {
                    Element element6 = SchemaHelper.createTag(element, "simpleType");
                    node = SchemaHelper.createTag(element, "restriction");
                    node.setAttribute("base", string);
                    element6.appendChild(node);
                    element4.appendChild(element6);
                }
            }
        }
    }

    public static String[] getUnionTypes(Element element) {
        String[] stringArray;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "union");
        if (nodeList.getLength() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = (Element)nodeList.item(0);
        if (element2.hasAttribute("memberTypes")) {
            stringArray = element2.getAttribute("memberTypes");
            StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray, " \t", false);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        } else {
            stringArray = element2.getChildNodes();
            for (int i = 0; i < stringArray.getLength(); ++i) {
                Element element3;
                NodeList nodeList2;
                Node node = stringArray.item(i);
                if (!(node instanceof Element) || !"simpleType".equals(node.getLocalName()) || (nodeList2 = ((Element)node).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction")).getLength() <= 0 || !(element3 = (Element)nodeList2.item(0)).hasAttribute("base")) continue;
                arrayList.add(element3.getAttribute("base"));
            }
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static Element getAnyByName(Element element, String string) {
        return SchemaHelper.getRef(element, "*", string);
    }

    public static Element getComplexTypeByName(Element element, String string) {
        return SchemaHelper.getRef(element, "complexType", string);
    }

    public static String[] getElementRef(Element element) {
        return SchemaHelper.getRef(element, "element");
    }

    public static String[] getAttributeRef(Element element) {
        return SchemaHelper.getRef(element, "attribute");
    }

    public static String[] getTypeRef(Element element) {
        return SchemaHelper.getRef(element, "type");
    }

    public static String[] getGroupRef(Element element) {
        return SchemaHelper.getRef(element, "group");
    }

    public static String[] getAttributeGroupRef(Element element) {
        return SchemaHelper.getRef(element, "attributeGroup");
    }

    public static Element searchForChildWithAttribute(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !(element2 = (Element)nodeList.item(i)).hasAttribute(string)) continue;
            return element2;
        }
        return null;
    }

    public static boolean updateListType(Element element, String string) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "list");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (element2.hasAttribute("itemType")) {
                element2.setAttribute("itemType", string);
                return true;
            }
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction");
            if (nodeList2.getLength() > 0) {
                Element element3 = (Element)nodeList2.item(0);
                element3.setAttribute("base", string);
                return true;
            }
            return false;
        }
        return false;
    }

    public static String getListType(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "list");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            if (element2.hasAttribute("itemType")) {
                return element2.getAttribute("itemType");
            }
            NodeList nodeList2 = element2.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "restriction");
            if (nodeList2.getLength() > 0) {
                Element element3 = (Element)nodeList2.item(0);
                return element3.getAttribute("base");
            }
            return null;
        }
        return null;
    }

    public static String[] getType(Element element, boolean bl, boolean bl2) {
        int n;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (bl2) {
            stringArray = SchemaHelper.getRef(element, "simpleType");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                arrayList.add(stringArray[n2]);
            }
        }
        if (bl) {
            stringArray = SchemaHelper.getRef(element, "complexType");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                arrayList.add(stringArray[n2]);
            }
        }
        if (bl2) {
            String string = "";
            if (element.getPrefix() != null) {
                string = element.getPrefix() + ":";
            }
            for (n = 0; n < PTYPES.length; ++n) {
                arrayList.add(string + PTYPES[n]);
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray2[n] = (String)arrayList.get(n);
        }
        return stringArray2;
    }

    public static Element getRef(Element element, String string, String string2) {
        String string3;
        Object object;
        if ("".equals(string2)) {
            return null;
        }
        String string4 = string2;
        int n = string2.indexOf(":");
        if (n > -1) {
            object = string2.substring(0, n);
            string3 = element.lookupNamespaceURI((String)object);
            if (string3 == null) {
                return null;
            }
            Element element2 = element.getOwnerDocument().getDocumentElement();
            if (element2.hasAttribute("targetNamespace") && !element2.getAttribute("targetNamespace").equals(string3)) {
                return null;
            }
            string4 = string2.substring(n + 1);
        }
        object = element.getChildNodes();
        string3 = null;
        for (int i = 0; i < object.getLength(); ++i) {
            Element element3;
            if (!(object.item(i) instanceof Element) || !string.equals((element3 = (Element)object.item(i)).getLocalName()) && !"*".equals(string) || !string4.equals(element3.getAttribute("name"))) continue;
            return element3;
        }
        return null;
    }

    private static String[] getRef(Element element, String string) {
        Object object;
        Object object2 = "";
        if (element.getAttribute("targetNamespace") != null && !"".equals(element.getAttribute("targetNamespace"))) {
            object = element.getAttributes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeName() == null || !node.getNodeName().startsWith("xmlns:") || !node.getNodeValue().equals(element.getAttribute("targetNamespace"))) continue;
                object2 = node.getNodeName().substring(6) + ":";
                break;
            }
            if ("".equals(object2)) {
                object2 = "editix:";
                element.setAttribute("xmlns:editix", element.getAttribute("targetNamespace"));
            }
        }
        object = element.getChildNodes();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < object.getLength(); ++i) {
            if (!(object.item(i) instanceof Element)) continue;
            Element element2 = (Element)object.item(i);
            if ("include".equals(element2.getLocalName()) || "redefine".equals(element2.getLocalName()) || "import".equals(element2.getLocalName())) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Element element3 = (Element)element2.getUserData("parsed");
                if (element3 == null) {
                    if (element2.getUserData("resolved") != null || "".equals(object6 = element2.getAttribute("schemaLocation"))) continue;
                    String string2 = (String)element.getUserData("path");
                    object5 = null;
                    try {
                        Object object7;
                        if (((String)object6).indexOf("://") > -1) {
                            object5 = XMLToolkit.getContentFromFileName(new URL((String)object6), null);
                        } else {
                            object7 = null;
                            if (string2 != null) {
                                object7 = new File(string2).getParentFile();
                            }
                            if (!((File)(object4 = new File((String)object6))).exists() && object7 != null) {
                                object4 = new File((File)object7, (String)object6);
                            }
                            object5 = XMLToolkit.getContentFromFileName(((File)object4).toString(), null);
                        }
                        object7 = DocumentBuilderFactory.newInstance();
                        ((DocumentBuilderFactory)object7).setNamespaceAware(true);
                        object4 = ((DocumentBuilderFactory)object7).newDocumentBuilder();
                        object3 = ((DocumentBuilder)object4).parse(new InputSource(new StringReader(((XMLFileData)object5).getContent())));
                        if (object3 != null && object3.getDocumentElement() != null) {
                            element3 = object3.getDocumentElement();
                            element2.setUserData("parsed", element3, null);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (element3 != null && (object6 = SchemaHelper.getRef(element3, string)) != null) {
                    for (int j = 0; j < ((String[])object6).length; ++j) {
                        object5 = object6[j];
                        int n = ((String)object5).indexOf(58);
                        if (n > -1) {
                            object5 = ((String)object5).substring(n + 1);
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        object4 = object2;
                        if ("import".equals(element2.getLocalName()) && !"".equals(object3 = element2.getAttribute("namespace"))) {
                            Element element4 = element2.getOwnerDocument().getDocumentElement();
                            String string3 = element4.lookupPrefix((String)object3);
                            if (string3 == null) {
                                for (int k = 1; k < 50; ++k) {
                                    if (element4.lookupPrefix("ed" + k) != null) continue;
                                    element4.setAttribute("xmlns:ed" + k, (String)object3);
                                    object2 = "ed" + k + ":";
                                    break;
                                }
                            } else {
                                object2 = string3 + ":";
                            }
                        }
                        arrayList.add((String)object2 + (String)object5);
                        object2 = object4;
                    }
                }
                element2.setUserData("resolved", "ok", null);
            }
            if (!string.equals(element2.getLocalName())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            if ("".equals(element2.getAttribute("name"))) continue;
            arrayList.add((String)object2 + element2.getAttribute("name"));
        }
        if (arrayList == null) {
            return new String[0];
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static Element getElementAtRow(Element element, int n) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            if (n == 0) {
                return (Element)nodeList.item(i);
            }
            --n;
        }
        return null;
    }

    public static Element createTag(Element element, String string) {
        String string2 = element.getPrefix();
        String string3 = string;
        if (string2 != null) {
            string3 = string2 + ":" + string3;
        }
        Element element2 = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), string3);
        return element2;
    }

    public static Element createElement(Element element, String string) {
        String string2 = element.getPrefix();
        String string3 = "element";
        if (string2 != null) {
            string3 = string2 + ":" + string3;
        }
        Element element2 = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), string3);
        element2.setAttribute("name", string);
        return element2;
    }

    public static Element createSimpleType(Element element, String string) {
        String string2 = element.getPrefix();
        String string3 = "simpleType";
        if (string2 != null) {
            string3 = string2 + ":" + string3;
        }
        Element element2 = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), string3);
        if (string != null) {
            element2.setAttribute("name", string);
        }
        return element2;
    }

    public static String getSimpleType(Element element, String string) {
        String string2 = element.getPrefix();
        if (string2 != null) {
            return string2 + ":" + string;
        }
        return string;
    }

    public static Element createAnyPart(Element element, String string, String string2) {
        String string3 = element.getPrefix();
        String string4 = string2;
        if (string3 != null && string2.indexOf(":") == -1) {
            string4 = string3 + ":" + string4;
        }
        Element element2 = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), string4);
        if (string != null) {
            element2.setAttribute("name", string);
        }
        return element2;
    }

    public static String[] getParts(Element element, int n) {
        int n2;
        Object object;
        String string = element.getPrefix();
        string = string == null ? "" : string + ":";
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            object = SchemaHelper.getElementAtRow(element, i);
            if (object.getNodeName().endsWith("include") || object.getNodeName().endsWith("import") || object.getNodeName().endsWith("redefine") || object.getNodeName().endsWith("annotation")) continue;
            bl = false;
            break;
        }
        String[] stringArray = new String[]{"element", "complexType", "simpleType", "attribute", "attributeGroup", "group", "include", "redefine", "import", "notation"};
        Collections.addAll(arrayList, stringArray);
        if (bl) {
            arrayList.add(0, "include");
            arrayList.add(1, "import");
            arrayList.add(2, "redefine");
            arrayList.add(3, "annotation");
        } else {
            object = element.getChildNodes();
            n2 = -1;
            for (int i = 0; i < object.getLength(); ++i) {
                if (!(object.item(i) instanceof Element)) continue;
                ++n2;
            }
            if (n2 == n) {
                arrayList.add("annotation");
            }
        }
        object = new String[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object[n2] = (String)arrayList.get(n2);
        }
        return object;
    }

    public static Element getRestrictionElement(Element element) {
        int n;
        NodeList nodeList;
        Element element2 = null;
        if ("element".equals(element.getLocalName()) || "attribute".equals(element.getLocalName())) {
            nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (!"simpleType".equals(nodeList.item(n).getLocalName())) continue;
                element2 = (Element)nodeList.item(n);
                break;
            }
        } else if ("simpleType".equals(element.getLocalName())) {
            element2 = element;
        }
        if (element2 == null) {
            return null;
        }
        nodeList = element2.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!"restriction".equals(nodeList.item(n).getLocalName())) continue;
            return (Element)nodeList.item(n);
        }
        return null;
    }

    public static int getCountForChildren(Element element, String[] stringArray) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(element2.getLocalName())) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean hasDOMElementChild(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public static String getTexts(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Text)) continue;
            Text text = (Text)nodeList.item(i);
            stringBuffer.append(text.getNodeValue());
        }
        return stringBuffer.toString();
    }

    public static Element getChildAt(Element element, int n, String[] stringArray) {
        NodeList nodeList = element.getChildNodes();
        int n2 = n;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(element2.getLocalName())) continue;
                if (n2 == 0) {
                    return element2;
                }
                --n2;
            }
        }
        return null;
    }

    public static boolean isFirstElement(Element element) {
        Element element2 = (Element)element.getParentNode();
        if (element2 == null) {
            return false;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || "annotation".equals(((Element)node).getLocalName())) continue;
            return node == element;
        }
        return false;
    }

    public static boolean isLastElement(Element element) {
        Element element2 = (Element)element.getParentNode();
        if (element2 == null) {
            return false;
        }
        NodeList nodeList = element2.getChildNodes();
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || "annotation".equals(((Element)node).getLocalName())) continue;
            if (node == element) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            return false;
        }
        return bl;
    }

    public static int getElementIndex(Element element) {
        Element element2 = (Element)element.getParentNode();
        if (element2 == null) {
            return -1;
        }
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != element) continue;
            return i;
        }
        return -1;
    }

    public static void cleanEmptyTextNode(Node node) {
        if (node == null) {
            return;
        }
        node = node.getFirstChild();
        while (node != null) {
            Object object;
            Node node2 = node;
            node = node.getNextSibling();
            if (node2.getNodeType() == 3) {
                object = node2.getNodeValue();
                boolean bl = true;
                for (int i = 0; i < ((String)object).length(); ++i) {
                    if (Character.isWhitespace(((String)object).charAt(i))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                node2.getParentNode().removeChild(node2);
                continue;
            }
            if (node2.getNodeType() != 1 || !(object = (Element)node2).hasChildNodes()) continue;
            SchemaHelper.cleanEmptyTextNode((Node)object);
        }
    }

    public static Element resolveXPathExpression(String string, Document document) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        Node node = document.getDocumentElement();
        if (node == null) {
            return null;
        }
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(91);
            String string3 = string2;
            int n2 = 1;
            if (n > -1) {
                int n3 = string2.indexOf(93);
                if (n3 > -1) {
                    n2 = Integer.parseInt(string2.substring(n + 1, n3));
                }
                string3 = string2.substring(0, n);
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getLocalName() == null || !node2.getLocalName().equals(string3) || --n2 != 0) continue;
                node = node2;
                continue block0;
            }
        }
        if (node instanceof Element) {
            return node;
        }
        return null;
    }

    public static String getXPathExpression(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            if (node instanceof Element) {
                Node node2 = node.getParentNode();
                NodeList nodeList = node2.getChildNodes();
                int n = 0;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (!(node3 instanceof Element)) continue;
                    if (node.getLocalName() != null && node.getLocalName().equals(node3.getLocalName())) {
                        ++n;
                    }
                    if (node3 != node) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.insert(0, "/");
                    }
                    stringBuffer.insert(0, node3.getLocalName() + "[" + n + "]");
                }
            } else if (node instanceof Document) {
                stringBuffer.insert(0, "/");
                break;
            }
            node = node.getParentNode();
        }
        return stringBuffer.toString();
    }

    public static boolean canHaveThisChild(Element element, Element element2) {
        return SchemaHelper.canHaveThisChild(element, element2.getLocalName());
    }

    public static boolean canHaveThisChild(Element element, String string) {
        String[] stringArray = SchemaHelper.getChildrenForElement(element);
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

