/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.xmldb;

import com.japisoft.editix.db.AbstractNodeDb;
import com.japisoft.editix.db.ContainerNodeDb;
import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.xmldb.XmlDbFileNodeDbImpl;
import com.japisoft.editix.db.xmldb.XmlDbRootDbImpl;
import javax.swing.tree.TreeNode;
import org.exist.xmldb.RemoteBinaryResource;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XmlDbContainerDbImpl
extends AbstractNodeDb
implements ContainerNodeDb {
    protected Collection col;
    private String cachedName = null;

    public XmlDbContainerDbImpl(Collection collection) {
        this.col = collection;
    }

    public void open() throws Exception {
        String[] stringArray;
        String[] stringArray2 = this.col.listChildCollections();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.addChild(new XmlDbContainerDbImpl(this.col.getChildCollection(stringArray2[i])));
            }
        }
        if ((stringArray = this.col.listResources()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addChild(new XmlDbFileNodeDbImpl(this, stringArray[i]));
            }
        }
    }

    public void close() {
        try {
            this.col.close();
            super.close();
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
    }

    public Collection getCollection() {
        return this.col;
    }

    public void delete(String string) throws Exception {
        Resource resource = this.col.getResource(string);
        if (resource == null) {
            throw new Exception("Unknown resource " + string);
        }
        this.col.removeResource(resource);
        for (int i = 0; i < this.children.size(); ++i) {
            XmlDbFileNodeDbImpl xmlDbFileNodeDbImpl;
            if (!(this.children.get(i) instanceof XmlDbFileNodeDbImpl) || !(xmlDbFileNodeDbImpl = (XmlDbFileNodeDbImpl)this.children.get(i)).toString().equals(string)) continue;
            this.children.remove(i);
            break;
        }
    }

    public String getContent(String string) throws Exception {
        Resource resource = this.col.getResource(string);
        if (resource == null) {
            throw new Exception("Unknown resource " + string);
        }
        if (resource instanceof RemoteBinaryResource) {
            RemoteBinaryResource remoteBinaryResource = (RemoteBinaryResource)resource;
            byte[] byArray = (byte[])remoteBinaryResource.getContent();
            return new String(byArray, 0, ((RemoteBinaryResource)resource).getContentLength());
        }
        Object object = resource.getContent();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public void setContent(String string, String string2) throws Exception {
        Resource resource = this.col.getResource(string);
        if (resource != null) {
            resource.setContent((Object)string2);
        } else {
            String string3 = "XMLResource";
            String string4 = string.toLowerCase();
            String string5 = string2;
            if (string4.endsWith("dtd") || string4.endsWith("css") || string4.endsWith("txt")) {
                string5 = "";
                string3 = "BinaryResource";
            }
            resource = this.col.createResource(string, string3);
            resource.setContent((Object)string5);
            if (resource == null) {
                throw new Exception("Can't create the file " + string);
            }
        }
        this.col.storeResource(resource);
    }

    public NodeDb[] request(String string) throws Exception {
        TreeNode treeNode = this.getParent();
        while (!(treeNode instanceof RootNodeDb)) {
            if ((treeNode = treeNode.getParent()) != null) continue;
            return null;
        }
        return ((XmlDbRootDbImpl)treeNode).request(this.col, string);
    }

    public String toString() {
        if (this.cachedName == null) {
            try {
                this.cachedName = this.col.getName();
                int n = this.cachedName.lastIndexOf("/");
                if (n > -1) {
                    this.cachedName = this.cachedName.substring(n + 1);
                }
            }
            catch (XMLDBException xMLDBException) {
                this.cachedName = "col";
            }
        }
        return this.cachedName;
    }

    public boolean canBeDeleted() {
        try {
            Service[] serviceArray = this.col.getServices();
            if (serviceArray != null) {
                for (int i = 0; i < serviceArray.length; ++i) {
                    if (!(serviceArray[i] instanceof CollectionManagementService)) continue;
                    return true;
                }
            }
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
        return false;
    }

    public boolean delete() throws Exception {
        if (this.col.getParentCollection() == null) {
            return super.delete();
        }
        Service[] serviceArray = this.col.getServices();
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!(serviceArray[i] instanceof CollectionManagementService)) continue;
            CollectionManagementService collectionManagementService = (CollectionManagementService)serviceArray[i];
            collectionManagementService.removeCollection(this.getPath());
            super.delete();
            return true;
        }
        return false;
    }

    public Collection getCollectionByName(String string) {
        try {
            XmlDbContainerDbImpl xmlDbContainerDbImpl;
            TreeNode treeNode;
            int n;
            for (n = 0; n < this.getChildCount(); ++n) {
                treeNode = this.getChildAt(n);
                if (!(treeNode instanceof XmlDbContainerDbImpl) || !(xmlDbContainerDbImpl = (XmlDbContainerDbImpl)treeNode).getCollection().getName().equals(string)) continue;
                return xmlDbContainerDbImpl.getCollection();
            }
            for (n = 0; n < this.getChildCount(); ++n) {
                Collection collection;
                treeNode = this.getChildAt(n);
                if (!(treeNode instanceof XmlDbContainerDbImpl) || (collection = (xmlDbContainerDbImpl = (XmlDbContainerDbImpl)treeNode).getCollectionByName(string)) == null) continue;
                return collection;
            }
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
        return null;
    }

    public ContainerNodeDb createSubContainer(String string) throws Exception {
        Service[] serviceArray = this.col.getServices();
        if (serviceArray != null) {
            for (int i = 0; i < serviceArray.length; ++i) {
                CollectionManagementService collectionManagementService;
                Collection collection;
                if (!(serviceArray[i] instanceof CollectionManagementService) || (collection = (collectionManagementService = (CollectionManagementService)serviceArray[i]).createCollection(this.getPath() + "/" + string)) == null) continue;
                XmlDbContainerDbImpl xmlDbContainerDbImpl = new XmlDbContainerDbImpl(collection);
                this.addChild(xmlDbContainerDbImpl);
                return xmlDbContainerDbImpl;
            }
        }
        return null;
    }

    public boolean canCreateSubContainer() {
        try {
            Service[] serviceArray = this.col.getServices();
            if (serviceArray != null) {
                for (int i = 0; i < serviceArray.length; ++i) {
                    if (!(serviceArray[i] instanceof CollectionManagementService)) continue;
                    return true;
                }
            }
        }
        catch (XMLDBException xMLDBException) {
            return false;
        }
        return false;
    }

    public String getPath() {
        try {
            String string = this.col.getName();
            if (string.indexOf("/") > -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            for (TreeNode treeNode = this.getParent(); treeNode != null && treeNode instanceof NodeDb; treeNode = treeNode.getParent()) {
                if (treeNode instanceof RootNodeDb) {
                    stringBuffer.insert(0, "db/");
                    break;
                }
                stringBuffer.insert(0, treeNode.toString() + "/");
            }
            return stringBuffer.toString();
        }
        catch (XMLDBException xMLDBException) {
            return null;
        }
    }
}

