/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.search.file;

import com.japisoft.editix.action.search.file.SearchResult;
import java.io.File;

public class SearchResultImpl
implements SearchResult {
    private String res = null;
    private int line = -1;
    private File source = null;
    private int nbResult = -1;
    private String type = null;

    public SearchResultImpl(String string, int n) {
        this.res = string;
        this.line = n;
        this.checkRes();
    }

    public SearchResultImpl(File file, int n) {
        this.res = file.getName();
        this.source = file;
        this.nbResult = n;
        this.checkRes();
    }

    public File getSource() {
        return this.source;
    }

    public int getLine() {
        return this.line;
    }

    public String getType() {
        if (this.source == null) {
            return null;
        }
        if (this.type == null) {
            this.type = this.source.toString();
            int n = this.type.lastIndexOf(".");
            this.type = n > -1 ? this.type.substring(n + 1).toLowerCase() : "xml";
        }
        return this.type;
    }

    private void checkRes() {
        if (this.res.length() > 20) {
            this.res = this.res.substring(0, 20) + "...";
        }
        this.res = this.res.trim();
        if (this.nbResult > 0) {
            this.res = this.res + " (" + this.nbResult + " matching)";
        }
    }

    public String toString() {
        return this.res;
    }
}

