/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.fop;

import com.japisoft.editix.action.fop.FOPDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.job.HeavyJob;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.XSLTTransformer;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ValidationException;
import org.xml.sax.SAXException;

public class FOPAction
extends AbstractAction
implements HeavyJob {
    XMLContainer fopContainer = null;

    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        if (EditixFactory.mustSaveDialog(xMLContainer)) {
            return;
        }
        ActionModel.activeActionById("save", actionEvent);
        if (!ActionModel.LAST_ACTION_STATE) {
            return;
        }
        FOPDialog fOPDialog = new FOPDialog();
        fOPDialog.init(xMLContainer);
        fOPDialog.setVisible(true);
        fOPDialog.dispose();
        if (fOPDialog.isOk()) {
            fOPDialog.store(xMLContainer);
            FOPAction.applyFO(EditixFrame.ACCESSOR.getSelectedContainer(), true);
        }
    }

    public String getName() {
        return "FOP Transforming";
    }

    public void dispose() {
        this.fopContainer = null;
    }

    public Object getSource() {
        return null;
    }

    public boolean isAlone() {
        return false;
    }

    public void run() {
        FOPAction.applyFO(this.fopContainer);
    }

    public void stopIt() {
    }

    public String getErrorMessage() {
        return null;
    }

    public static void applyFO(XMLContainer xMLContainer, boolean bl) {
        if (!bl) {
            FOPAction.applyFO(xMLContainer);
        } else {
            FOPAction fOPAction = (FOPAction)ActionModel.restoreAction("fot");
            if (fOPAction == null) {
                System.err.println("Can't find action for :fot");
                return;
            }
            fOPAction.fopContainer = xMLContainer;
            JobManager.addJob(fOPAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyFO(XMLContainer xMLContainer) {
        String string = (String)xMLContainer.getProperty("fo.render");
        String string2 = (String)xMLContainer.getProperty("fo.output");
        boolean bl = "true".equals(xMLContainer.getProperty("fo.viewer"));
        FileOutputStream fileOutputStream = null;
        if (string2 != null && string2.length() > 1) {
            try {
                fileOutputStream = new FileOutputStream(string2);
            }
            catch (Throwable throwable) {
                xMLContainer.getErrorManager().notifyError("Can't use " + string2);
                return;
            }
        } else if (!"-".equals(string2)) {
            EditixFactory.buildAndShowErrorDialog("No output choosen !");
            return;
        }
        FopFactory fopFactory = FopFactory.newInstance();
        Fop fop = null;
        try {
            if ("PDF".equals(string)) {
                fop = fopFactory.newFop("application/pdf", (OutputStream)fileOutputStream);
            } else if ("PRINT".equals(string)) {
                fop = fopFactory.newFop("application/X-fop-print");
            } else if ("PCL".equals(string)) {
                fop = fopFactory.newFop("application/x-pcl", (OutputStream)fileOutputStream);
            } else if ("PS".equals(string)) {
                fop = fopFactory.newFop("application/postscript", (OutputStream)fileOutputStream);
            } else if ("TXT".equals(string)) {
                fop = fopFactory.newFop("text/plain", (OutputStream)fileOutputStream);
            } else if ("SVG".equals(string)) {
                fop = fopFactory.newFop("image/svg+xml", (OutputStream)fileOutputStream);
            } else if ("RTF".equals(string)) {
                fop = fopFactory.newFop("application/rtf", (OutputStream)fileOutputStream);
            }
        }
        catch (FOPException fOPException) {
            EditixFactory.buildAndShowErrorDialog("Error :" + fOPException.getMessage());
        }
        try {
            try {
                try {
                    TransformerFactory transformerFactory = XSLTTransformer.getTransformerFactory();
                    Transformer transformer = transformerFactory.newTransformer();
                    String string3 = (String)xMLContainer.getProperty("fo.source");
                    if (string3 == null) {
                        string3 = xMLContainer.getCurrentDocumentLocation();
                    }
                    StreamSource streamSource = string3.indexOf("://") == -1 ? new StreamSource(new File(string3)) : new StreamSource(string3);
                    SAXResult sAXResult = new SAXResult(fop.getDefaultHandler());
                    transformer.transform(streamSource, sAXResult);
                    if (bl) {
                        Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + string2);
                    }
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    xMLContainer.getErrorManager().notifyError(transformerConfigurationException.getMessage(), transformerConfigurationException.getLocator() != null ? transformerConfigurationException.getLocator().getLineNumber() : -1);
                }
                catch (FOPException fOPException) {
                    xMLContainer.getErrorManager().notifyError(fOPException.getMessage());
                }
                catch (TransformerException transformerException) {
                    int n;
                    String string4 = null;
                    int n2 = -1;
                    if (transformerException.getException() instanceof SAXException) {
                        int n3;
                        String string5;
                        int n4;
                        int n5;
                        SAXException sAXException = (SAXException)transformerException.getException();
                        string4 = sAXException.getMessage();
                        if (sAXException instanceof ValidationException) {
                            ValidationException validationException = (ValidationException)sAXException;
                        }
                        if (n2 == -1 && string4 != null && (n5 = string4.indexOf(58)) > -1 && (n4 = string4.indexOf(58, n5 + 1)) > -1) {
                            string5 = string4.substring(n5 + 1, n4);
                            try {
                                n2 = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (n2 == -1 && string4 != null && (n3 = string4.indexOf(40)) > -1 && (n4 = string4.indexOf(47, n3 + 1)) > -1) {
                            string5 = string4.substring(n3 + 1, n4);
                            try {
                                n2 = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if (string4 == null) {
                        string4 = transformerException.getLocalizedMessage();
                    }
                    if ((n = string4.lastIndexOf("Exception")) > -1) {
                        string4 = string4.substring(n + 10);
                    }
                    xMLContainer.getErrorManager().notifyError(null, true, null, n2 - 1, 0, -1, string4, false);
                    xMLContainer.getErrorManager().stopErrorProcessing();
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            EditixFactory.buildAndShowErrorDialog("Can't use " + xMLContainer.getCurrentDocumentLocation());
            return;
        }
        catch (IOException iOException) {
            EditixFactory.buildAndShowErrorDialog("Can't use " + xMLContainer.getCurrentDocumentLocation());
        }
    }
}

