/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file.imp;

import com.japisoft.editix.toolkit.Toolkit;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.w3c.tidy.Tidy;

public class HTMLImport
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
        } else {
            JFileChooser jFileChooser = EditixFactory.buildFileChooserForDocumentType("XHTML");
            if (jFileChooser.showOpenDialog(EditixFrame.ACCESSOR) == 0) {
                try {
                    byte[] byArray = HTMLImport.convertHTMLInputStream(new FileInputStream(jFileChooser.getSelectedFile()));
                    if (byArray != null) {
                        IXMLPanel iXMLPanel = EditixFactory.buildNewContainer("XHTML", (String)null);
                        XMLContainer xMLContainer = iXMLPanel.getMainContainer();
                        xMLContainer.setText(Toolkit.getEncodedString(byArray).getContent());
                        EditixFrame.ACCESSOR.addContainer(iXMLPanel);
                    }
                }
                catch (Throwable throwable) {
                    ApplicationModel.debug(throwable);
                    EditixFactory.buildAndShowErrorDialog("Can't import : " + throwable.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertHTMLInputStream(InputStream inputStream) {
        Tidy tidy = new Tidy();
        tidy.setXmlOut(true);
        tidy.setNumEntities(true);
        tidy.setQuoteNbsp(true);
        tidy.setQuiet(true);
        tidy.setErrout(new PrintWriter(new StringWriter()));
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                tidy.parse((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
                byteArrayOutputStream.close();
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            ApplicationModel.debug(exception);
            EditixFactory.buildAndShowErrorDialog("Can't import : " + exception.getMessage());
            return null;
        }
    }
}

