/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file.export;

import com.japisoft.editix.action.file.export.ClassGenerator;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class ExportJavaAction
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            EditixFactory.buildAndShowErrorDialog("No document");
            return;
        }
        if (xMLContainer.getCurrentDocumentLocation() == null) {
            EditixFactory.buildAndShowErrorDialog("Your must save your document");
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showSaveDialog(EditixFrame.ACCESSOR) == 0) {
            String string = EditixFactory.buildAndShowInputDialog("Java package ?");
            if (string == null) {
                string = "editix";
            }
            try {
                ClassGenerator classGenerator = new ClassGenerator(xMLContainer.getCurrentDocumentLocation(), jFileChooser.getSelectedFile().toString(), string);
                this.copyJavaFile("javatemplate/AbstractElement.javat", jFileChooser.getSelectedFile(), string);
                this.copyJavaFile("javatemplate/ObjectBuilder.javat", jFileChooser.getSelectedFile(), string);
                this.copyJavaFile("javatemplate/SaxHandler.javat", jFileChooser.getSelectedFile(), string);
                this.copyJavaFile("javatemplate/Tools.javat", jFileChooser.getSelectedFile(), string);
            }
            catch (Throwable throwable) {
                EditixFactory.buildAndShowErrorDialog("Can't create classes : " + throwable.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJavaFile(String string, File file, String string2) {
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL == null) {
            ApplicationModel.debug("Can't write java class " + string);
        } else {
            try {
                InputStream inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                try {
                    bufferedReader.readLine();
                    int n = string.indexOf("/");
                    string = string.substring(n + 1);
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(file, string.substring(0, string.length() - 1))));
                    try {
                        if (string2 != null) {
                            bufferedWriter.write("package " + string2 + ";");
                            bufferedWriter.newLine();
                        }
                        String string3 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(string3);
                            bufferedWriter.newLine();
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

