/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.docbook;

import com.japisoft.editix.action.docbook.ParametersModel;
import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdesktop.layout.GroupLayout;

public class DocBookDialogPanel
extends JPanel
implements ItemListener,
TreeSelectionListener,
MouseMotionListener {
    private ParametersModel model = null;
    private JCheckBox cbPreview;
    private JComboBox cbType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTable paramTable;
    private JTree paramTree;
    private JPanel pnlOutput;
    private JPanel pnlParameters;
    private JScrollPane spParamTable;
    private JScrollPane spParamTree;
    private JSplitPane spParameters;
    private FileTextField tfOutput;
    private JTabbedPane tp;

    public DocBookDialogPanel() {
        this.initComponents();
        this.initModels();
        this.tfOutput.setEnabled(false);
    }

    private void initModels() {
        this.cbType.addItem("No selection");
        this.cbType.addItem("HTML");
        this.cbType.addItem("HTML Help");
        this.cbType.addItem("XHTML");
        this.cbType.addItem("Java Help");
        this.cbType.addItem("FO");
        this.cbType.addItem("PDF");
        this.cbType.addItem("XML");
        this.cbType.addItem("PRINT");
        this.cbType.addItem("PCL");
        this.cbType.addItem("PS");
        this.cbType.addItem("TXT");
        this.cbType.addItem("SVG");
        this.model = new ParametersModel();
        this.model.read();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Types");
        List list = this.model.getTypes();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
        }
        this.paramTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
    }

    public void addNotify() {
        super.addNotify();
        if (this.cbType != null) {
            this.cbType.addItemListener(this);
            this.paramTree.addTreeSelectionListener(this);
            this.paramTable.addMouseMotionListener(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbType.removeItemListener(this);
        this.paramTree.removeTreeSelectionListener(this);
        this.paramTable.removeMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.paramTable.rowAtPoint(mouseEvent.getPoint());
        if (n > -1) {
            String string = (String)this.paramTable.getValueAt(n, 0);
            this.paramTable.setToolTipText(this.model.getHelp(string));
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.paramTree.getSelectionPath().getLastPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        if (string == null) {
            return;
        }
        this.synchronizeTableModel();
        List list = this.model.getParameters(string);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Parameter", "Value"}, 0){

            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            String string3 = this.model.getValue(string2);
            defaultTableModel.addRow(new Object[]{string2, string3});
        }
        this.paramTable.setModel(defaultTableModel);
    }

    private void synchronizeTableModel() {
        TableModel tableModel;
        if (this.paramTable.getCellEditor() != null) {
            this.paramTable.getCellEditor().stopCellEditing();
        }
        if ((tableModel = this.paramTable.getModel()).getColumnCount() != 2) {
            return;
        }
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            String string2 = (String)tableModel.getValueAt(i, 1);
            if (string2 != null && !"".equals(string2)) {
                this.model.setValue(string, string2);
                continue;
            }
            this.model.setValue(string, null);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.tfOutput.setEnabled(this.cbType.getSelectedIndex() > 0);
    }

    public void init(XMLContainer xMLContainer) {
        this.cbType.setSelectedItem(xMLContainer.getProperty("docBook.render", "HTML"));
        this.tfOutput.setText("" + xMLContainer.getProperty("docBook.output", ""));
        for (int i = 5; i < 100; ++i) {
            this.model.setValue((String)xMLContainer.getProperty("xslt.param.name." + i), (String)xMLContainer.getProperty("xslt.param.value." + i));
        }
        this.cbPreview.setSelected("true".equals(xMLContainer.getProperty("docBook.application")));
    }

    public void store(XMLContainer xMLContainer) {
        this.synchronizeTableModel();
        for (int i = 5; i < 100; ++i) {
            xMLContainer.setProperty("xslt.param.value." + i, null);
            xMLContainer.setProperty("xslt.param.name." + i, null);
        }
        Set set = this.model.getValues();
        int n = 5;
        for (Map.Entry entry : set) {
            if (entry.getValue() != null) {
                xMLContainer.setProperty("xslt.param.value." + n, entry.getValue());
                xMLContainer.setProperty("xslt.param.name." + n, entry.getKey());
            }
            ++n;
        }
        if (this.cbType.getSelectedIndex() == 0) {
            xMLContainer.setProperty("docBook.render", null);
            xMLContainer.setProperty("docBook.ok", null);
            xMLContainer.setProperty("docBook.output", null);
        } else {
            xMLContainer.setProperty("docBook.render", this.cbType.getSelectedItem());
            xMLContainer.setProperty("docBook.ok", "true");
            xMLContainer.setProperty("docBook.output", this.tfOutput.getText());
        }
        xMLContainer.setProperty("docBook.application", "" + this.cbPreview.isSelected());
    }

    private void initComponents() {
        this.tp = new JTabbedPane();
        this.pnlOutput = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbType = new JComboBox();
        this.cbPreview = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.tfOutput = new FileTextField((String)null, (String)null);
        this.pnlParameters = new JPanel();
        this.spParameters = new JSplitPane();
        this.spParamTree = new JScrollPane();
        this.paramTree = new JTree();
        this.spParamTable = new JScrollPane();
        this.paramTable = new JTable();
        this.jLabel1.setText("Type");
        this.jLabel2.setText("Output file");
        this.cbPreview.setText("Display with an external application (acrobat...)");
        this.cbPreview.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbPreview.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlOutput);
        this.pnlOutput.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbType, 0, 424, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.tfOutput, -1, 424, Short.MAX_VALUE).add((Component)this.cbPreview)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cbType, -2, -1, -2).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.tfOutput, -2, -1, -2).add(23, 23, 23).add((Component)this.cbPreview).addContainerGap(102, Short.MAX_VALUE)));
        this.tp.addTab("Output", this.pnlOutput);
        this.spParameters.setDividerLocation(170);
        this.spParameters.setOneTouchExpandable(true);
        this.spParamTree.setViewportView(this.paramTree);
        this.spParameters.setLeftComponent(this.spParamTree);
        this.spParamTable.setViewportView(this.paramTable);
        this.spParameters.setRightComponent(this.spParamTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.pnlParameters);
        this.pnlParameters.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spParameters, -1, 444, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spParameters, -1, 260, Short.MAX_VALUE));
        this.tp.addTab("Parameters", this.pnlParameters);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.tp, -1, 449, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.tp, -1, 288, Short.MAX_VALUE));
    }
}

