/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.cdlib.xtf.textEngine.DocHit;

public class TotalHitsComparator
implements SortComparatorSource {
    public ScoreDocComparator newComparator(IndexReader reader, String fieldName) throws IOException {
        return new HitsComp();
    }

    private class HitsComp
    implements ScoreDocComparator {
        private HitsComp() {
        }

        public int compare(ScoreDoc d1, ScoreDoc d2) {
            int o2;
            assert (d1 instanceof DocHit);
            assert (d2 instanceof DocHit);
            int o1 = ((DocHit)d1).totalSnippets();
            if (o1 < (o2 = ((DocHit)d2).totalSnippets())) {
                return -1;
            }
            if (o1 > o2) {
                return 1;
            }
            return 0;
        }

        public Comparable sortValue(ScoreDoc doc) {
            assert (doc instanceof DocHit);
            return new Integer(((DocHit)doc).totalSnippets());
        }

        public int sortType() {
            return 9;
        }
    }
}

