/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;

public class NativeFSDirectory
extends FSDirectory {
    private static HashMap<File, LockFactory> lockFactories = new HashMap();

    public static FSDirectory getDirectory(String path) throws IOException {
        return NativeFSDirectory.getDirectory(new File(path));
    }

    public static FSDirectory getDirectory(File file) throws IOException {
        file = new File(file.getCanonicalPath());
        return NativeFSDirectory.getDirectory(file, NativeFSDirectory.getLockFactory(file));
    }

    private static synchronized LockFactory getLockFactory(File f) throws IOException {
        LockFactory ret = lockFactories.get(f);
        if (ret == null) {
            ret = new NativeFSLockFactory(f);
            lockFactories.put(f, ret);
        }
        return ret;
    }
}

