/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.test;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.cdlib.xtf.crossQuery.CrossQuery;
import org.cdlib.xtf.dynaXML.DynaXML;
import org.cdlib.xtf.test.FakeOutputStream;
import org.cdlib.xtf.test.FakeServletConfig;
import org.cdlib.xtf.test.FakeServletContext;
import org.cdlib.xtf.test.FakeServletRequest;
import org.cdlib.xtf.test.FakeServletResponse;
import org.cdlib.xtf.util.Trace;

public class FakeServletContainer {
    private static CrossQuery crossQuery;
    private static DynaXML dynaXML;
    private static FakeServletConfig config;

    private static void service(HttpServlet servlet, String url) throws ServletException, IOException {
        FakeServletRequest req = new FakeServletRequest(url);
        FakeOutputStream out = new FakeOutputStream();
        FakeServletResponse res = new FakeServletResponse(out);
        servlet.service((ServletRequest)req, (ServletResponse)res);
        System.out.print(out.buf.toString());
    }

    private static void service(String url) throws ServletException, IOException, InterruptedException {
        Pattern pausePat = Pattern.compile("pause\\((\\d+)\\)");
        Matcher m = pausePat.matcher(url);
        if (m.matches()) {
            int secs = Integer.parseInt(m.group(1));
            Trace.info(String.format("Pausing %s seconds", secs));
            Thread.sleep(secs);
        } else if (url.contains("/search")) {
            if (crossQuery == null) {
                crossQuery = new CrossQuery();
                crossQuery.init(config);
            }
            Trace.info("Servicing crossQuery URL '" + url + "'");
            FakeServletContainer.service(crossQuery, url);
        } else if (url.contains("/view")) {
            if (dynaXML == null) {
                dynaXML = new DynaXML();
                dynaXML.init(config);
            }
            Trace.info("Servicing dynaXML URL '" + url + "'");
            FakeServletContainer.service(dynaXML, url);
        } else {
            Trace.warning("Unrecognized URL pattern: '" + url + "'");
        }
    }

    public static void main(String[] args) throws InterruptedException, ServletException, IOException {
        FakeServletContext context = new FakeServletContext();
        config = new FakeServletConfig(context, System.getProperty("user.dir"), "crossQuery");
        int i = 0;
        while (i < args.length) {
            FakeServletContainer.service(args[i]);
            ++i;
        }
    }
}

