/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.pipe;

import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class BufferedRandomAccessFile
extends RandomAccessFileOrArray {
    RandomAccessFile baseFile;
    byte prevByte;
    boolean havePrevByte = false;
    final int BUFFER_SIZE = 4096;
    byte[] buffer = new byte[4096];
    int startOffset = 0;
    int bufferLength = 0;
    int bufferPos = 0;
    int bufferFilePointer = 0;

    public BufferedRandomAccessFile(String filename) throws IOException {
        super(filename, false, true);
        this.baseFile = new RandomAccessFile(filename, "r");
    }

    public void pushBack(byte b) {
        this.prevByte = b;
        this.havePrevByte = true;
    }

    private void fillBuffer() throws IOException {
        this.bufferFilePointer = (int)this.baseFile.getFilePointer();
        this.bufferLength = this.baseFile.read(this.buffer);
        this.bufferPos = 0;
    }

    public int read() throws IOException {
        if (this.havePrevByte) {
            this.havePrevByte = false;
            return this.prevByte & 0xFF;
        }
        if (this.bufferPos >= this.bufferLength) {
            this.fillBuffer();
            if (this.bufferPos >= this.bufferLength) {
                return -1;
            }
        }
        return this.buffer[this.bufferPos++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toCopy;
        int origLen = len;
        if (this.havePrevByte && len > 0) {
            this.havePrevByte = false;
            b[0] = this.prevByte;
            ++off;
            --len;
        }
        if ((toCopy = Math.min(this.bufferLength - this.bufferPos, len)) > 0) {
            System.arraycopy(this.buffer, this.bufferPos, b, off, toCopy);
            this.bufferPos += toCopy;
            off += toCopy;
            len -= toCopy;
        }
        if (len > 0) {
            int nRead = this.baseFile.read(b, off, len);
            off += nRead;
            len -= nRead;
        }
        return origLen - len;
    }

    public int skipBytes(int n) throws IOException {
        int nBufSkip;
        int origN = n;
        if (this.havePrevByte && n > 0) {
            this.havePrevByte = false;
            --n;
        }
        if ((nBufSkip = Math.min(this.bufferLength - this.bufferPos, n)) > 0) {
            this.bufferPos += nBufSkip;
            n -= nBufSkip;
        }
        if (n > 0) {
            this.baseFile.seek(this.baseFile.getFilePointer() + (long)n);
            n = 0;
        }
        return Math.max(0, origN - n);
    }

    public void reOpen() throws IOException {
        this.seek(0);
    }

    public boolean isOpen() {
        return this.baseFile != null;
    }

    public void close() throws IOException {
        this.havePrevByte = false;
        if (this.baseFile != null) {
            this.baseFile.close();
            this.baseFile = null;
        }
        super.close();
    }

    public void setStartOffset(int off) {
        this.startOffset = off;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int length() throws IOException {
        return (int)this.baseFile.length() - this.startOffset;
    }

    public void seek(int pos) throws IOException {
        this.havePrevByte = false;
        if (pos >= this.bufferFilePointer && pos - this.bufferFilePointer < this.bufferLength) {
            this.bufferPos = pos - this.bufferFilePointer;
            return;
        }
        this.baseFile.seek(pos + this.startOffset);
        this.bufferPos = 0;
        this.bufferLength = 0;
        this.bufferFilePointer = pos;
    }

    public void seek(long pos) throws IOException {
        this.seek((int)pos);
    }

    public int getFilePointer() throws IOException {
        return this.bufferFilePointer + this.bufferPos - this.startOffset - (this.havePrevByte ? 1 : 0);
    }

    public ByteBuffer getNioByteBuffer() throws IOException {
        throw new RuntimeException("Not supported");
    }
}

