/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML.test;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import org.cdlib.xtf.dynaXML.DefaultDocLocator;
import org.cdlib.xtf.dynaXML.DocLocator;
import org.cdlib.xtf.dynaXML.DocRequest;
import org.cdlib.xtf.dynaXML.DynaXML;
import org.cdlib.xtf.dynaXML.InvalidDocumentException;
import org.cdlib.xtf.lazyTree.SearchTree;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.test.FakeServletConfig;
import org.cdlib.xtf.test.FakeServletContext;
import org.cdlib.xtf.test.FakeServletRequest;
import org.cdlib.xtf.test.FakeServletResponse;
import org.cdlib.xtf.test.NullOutputStream;
import org.cdlib.xtf.textEngine.DefaultQueryProcessor;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.IndexWarmer;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textIndexer.IndexInfo;
import org.cdlib.xtf.util.AttribList;
import org.xml.sax.SAXException;

public class TestableDynaXML
extends DynaXML {
    private String baseDir;
    private String indexDirOverride;
    private IndexWarmer indexWarmer;
    private ThreadLocal<Integer> nHits = new ThreadLocal();

    public TestableDynaXML(String baseDir) throws ServletException {
        this.baseDir = baseDir;
        FakeServletContext context = new FakeServletContext();
        FakeServletConfig config = new FakeServletConfig(context, baseDir, "dynaXML");
        super.init((ServletConfig)config);
    }

    public void overrideIndexDir(String dir) {
        this.indexDirOverride = dir;
    }

    public void setIndexWarmer(IndexWarmer warmer) {
        this.indexWarmer = warmer;
    }

    public int nHits() {
        return this.nHits.get();
    }

    protected void setupTrace(TextConfig config) {
    }

    protected DocRequest runDocReqParser(HttpServletRequest req, AttribList attribs) throws Exception {
        DocRequest docRequest = super.runDocReqParser(req, attribs);
        if (this.indexDirOverride != null && docRequest.query != null) {
            docRequest.query.indexPath = this.indexDirOverride;
        }
        return docRequest;
    }

    public QueryProcessor createQueryProcessor() {
        DefaultQueryProcessor processor = new DefaultQueryProcessor();
        processor.setXtfHome(this.baseDir);
        if (this.indexWarmer == null) {
            this.indexWarmer = new IndexWarmer(this.baseDir, 0);
        }
        processor.setIndexWarmer(this.indexWarmer);
        return processor;
    }

    public void service(String url) throws ServletException, IOException {
        FakeServletRequest req = new FakeServletRequest(url);
        NullOutputStream out = new NullOutputStream();
        FakeServletResponse res = new FakeServletResponse(out);
        super.service(req, res);
    }

    protected Source getSourceDoc(DocRequest docReq, Transformer transformer) throws InvalidDocumentException, IOException, SAXException, ParserConfigurationException {
        Source src = super.getSourceDoc(docReq, transformer);
        if (src instanceof SearchTree) {
            this.nHits.set(((SearchTree)src).getTotalHits());
        } else {
            this.nHits.set(0);
        }
        return src;
    }

    protected boolean authenticate(DocRequest docReq, HttpServletRequest req, HttpServletResponse res) throws Exception {
        return true;
    }

    protected void genErrorPage(HttpServletRequest req, HttpServletResponse res, Exception exc) {
        throw new RuntimeException(exc);
    }

    public DocLocator createDocLocator() {
        DefaultDocLocator loc = new DefaultDocLocator(){

            public File calcLazyPath(File xtfHome, File idxConfigFile, String idxName, File srcTextFile, boolean createDir) throws IOException {
                if (TestableDynaXML.this.indexDirOverride == null) {
                    return super.calcLazyPath(xtfHome, idxConfigFile, idxName, srcTextFile, createDir);
                }
                IndexInfo idxInfo = IndexUtil.getIndexInfo(idxConfigFile, idxName);
                String oldIndexPath = idxInfo.indexPath;
                try {
                    idxInfo.indexPath = TestableDynaXML.this.indexDirOverride;
                    File file = IndexUtil.calcLazyPath(xtfHome, idxInfo, srcTextFile, createDir);
                    idxInfo.indexPath = oldIndexPath;
                    return file;
                }
                catch (Throwable throwable) {
                    try {
                        idxInfo.indexPath = oldIndexPath;
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        loc.setServlet(this);
        return loc;
    }
}

