/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public abstract class ProgressTracker
implements Cloneable {
    private float loPct;
    private float hiPct;
    private int minInterval = 30000;
    private IntHolder prevPctDone = new IntHolder();
    private LongHolder prevTime = new LongHolder();
    private StringHolder prevDescrip = new StringHolder();

    public ProgressTracker() {
        this(0.0f, 100.0f);
    }

    public ProgressTracker(float loPct, float hiPct) {
        this.loPct = loPct;
        this.hiPct = hiPct;
        this.prevPctDone.value = -1;
    }

    public void setMinInterval(int millisecs) {
        this.minInterval = millisecs;
    }

    public ProgressTracker[] split(long work1, long work2) {
        return this.split(new long[]{work1, work2});
    }

    public ProgressTracker[] split(long work1, long work2, long work3) {
        return this.split(new long[]{work1, work2, work3});
    }

    public ProgressTracker[] split(long work1, long work2, long work3, long work4) {
        return this.split(new long[]{work1, work2, work3, work4});
    }

    public ProgressTracker[] split(long[] works) {
        long total = 0L;
        int i = 0;
        while (i < works.length) {
            total += works[i];
            ++i;
        }
        ProgressTracker[] out = new ProgressTracker[works.length];
        long accum = 0L;
        int i2 = 0;
        while (i2 < works.length) {
            out[i2] = (ProgressTracker)this.clone();
            out[i2].loPct = this.loPct + (float)accum * (this.hiPct - this.loPct) / (float)total;
            out[i2].hiPct = this.loPct + (float)(accum += works[i2]) * (this.hiPct - this.loPct) / (float)total;
            ++i2;
        }
        return out;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void progress(long workDone, long totalWork, String descrip) {
        this.progress(workDone, totalWork, descrip, false);
    }

    public void progress(long workDone, long totalWork, String descrip, boolean force) {
        int pctDone = (int)(this.loPct + (float)workDone * (this.hiPct - this.loPct) / (float)totalWork);
        if (!force && pctDone <= this.prevPctDone.value) {
            return;
        }
        if (!force && System.currentTimeMillis() - this.prevTime.value < (long)this.minInterval) {
            return;
        }
        this.report(pctDone, descrip.equals(this.prevDescrip.value) ? "" : descrip);
        this.prevTime.value = System.currentTimeMillis();
        this.prevPctDone.value = pctDone;
        this.prevDescrip.value = descrip;
    }

    public abstract void report(int var1, String var2);

    private class IntHolder {
        int value;

        private IntHolder() {
        }
    }

    private class LongHolder {
        long value;

        private LongHolder() {
        }
    }

    private class StringHolder {
        String value;

        private StringHolder() {
        }
    }
}

