/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public class IntList {
    private int[] data;
    private int size = 0;

    public IntList() {
        this(10);
    }

    public IntList(int initialCapacity) {
        this.data = new int[initialCapacity];
    }

    public final void add(int value) {
        if (this.size == this.data.length) {
            this.resize(Math.max(this.size + 5, this.size * 3 / 2));
        }
        this.data[this.size++] = value;
    }

    public final void ensureCapacity(int cap) {
        if (cap > this.data.length) {
            this.resize(cap);
        }
    }

    public final void compact() {
        this.resize(this.size);
    }

    public final void resize(int newSize) {
        if (newSize != this.data.length) {
            int[] oldData = this.data;
            this.data = new int[newSize];
            System.arraycopy(oldData, 0, this.data, 0, Math.min(this.size, newSize));
            this.size = Math.min(this.size, newSize);
        }
    }

    public final int[] toArray() {
        int[] ret = new int[this.size];
        System.arraycopy(this.data, 0, ret, 0, this.size);
        return ret;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    public final int get(int index) {
        return this.data[index];
    }

    public final int getLast() {
        return this.data[this.size - 1];
    }

    public final void set(int index, int value) {
        this.data[index] = value;
    }

    public final void fill(int value) {
        Arrays.fill(this.data, value);
    }

    public final void sort() {
        this.compact();
        Arrays.sort(this.data);
    }

    public final int binarySearch(int searchFor) {
        this.compact();
        return Arrays.binarySearch(this.data, searchFor);
    }

    public final int[] calcSortMap() {
        int[] map = new int[this.size];
        int i = 0;
        while (i < this.size) {
            if (this.data[i] < 0) {
                throw new RuntimeException("This radix-sort cannot handle negative numbers");
            }
            map[i] = i;
            ++i;
        }
        int MAX_BITS = 32;
        short[] curByte = new short[this.size];
        int[] count = new int[256];
        int[] newMap = new int[this.size];
        int shift = 0;
        while (shift < 32) {
            Arrays.fill(count, 0);
            i = 0;
            while (i < this.size) {
                curByte[i] = (short)(this.data[map[i]] >> shift & 0xFF);
                count[curByte[i]] = count[curByte[i]] + 1;
                ++i;
            }
            int pos = 0;
            i = 0;
            while (i < 256) {
                int tmp = pos;
                pos += count[i];
                count[i] = tmp;
                ++i;
            }
            i = 0;
            while (i < this.size) {
                short s = curByte[i];
                int n = count[s];
                count[s] = n + 1;
                newMap[n] = map[i];
                ++i;
            }
            int[] tmp = map;
            map = newMap;
            newMap = tmp;
            shift += 8;
        }
        int prev = Integer.MIN_VALUE;
        i = 0;
        while (i < this.size) {
            int tmp = this.data[map[i]];
            if (tmp < prev) {
                throw new RuntimeException("Fatal internal error: sort algorithm has a bug");
            }
            prev = tmp;
            ++i;
        }
        return map;
    }

    public final void remap(int[] map) {
        int[] newData = new int[this.size];
        assert (map.length == this.size);
        int i = 0;
        while (i < this.size) {
            newData[i] = this.data[map[i]];
            ++i;
        }
        this.data = newData;
    }
}

