/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.lucene.spelt.FreqData;

public class FreqDataTest
extends TestCase {
    public void testFreqData() throws IOException {
        FreqData data = new FreqData();
        data.add("foo", 1);
        data.add("bar", 1);
        data.add("foo", 2);
        data.add("baz", 89);
        FreqDataTest.assertEquals((int)data.get("foo"), (int)3);
        FreqDataTest.assertEquals((int)data.get("bar"), (int)1);
        FreqDataTest.assertEquals((int)data.get("baz"), (int)89);
        data.add("foo", "bar", 5);
        data.add("bar", "foo", 7);
        FreqDataTest.assertEquals((int)data.get("foo", "bar"), (int)5);
        FreqDataTest.assertEquals((int)data.get("bar", "foo"), (int)7);
        File file = File.createTempFile("FreqDataTest", null);
        try {
            data.save(file);
            FreqData data2 = new FreqData();
            data2.add(file);
            FreqDataTest.assertEquals((int)data2.get("foo"), (int)3);
            FreqDataTest.assertEquals((int)data2.get("bar"), (int)1);
            FreqDataTest.assertEquals((int)data2.get("baz"), (int)89);
            FreqDataTest.assertEquals((int)data2.get("foo", "bar"), (int)5);
            FreqDataTest.assertEquals((int)data2.get("bar", "foo"), (int)7);
            data.add(file);
            FreqDataTest.assertEquals((int)data.get("foo"), (int)6);
            FreqDataTest.assertEquals((int)data.get("bar"), (int)2);
            FreqDataTest.assertEquals((int)data.get("baz"), (int)178);
            FreqDataTest.assertEquals((int)data.get("foo", "bar"), (int)10);
            FreqDataTest.assertEquals((int)data.get("bar", "foo"), (int)14);
        }
        finally {
            file.delete();
        }
    }
}

