/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.EvaluableItem;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public abstract class Expression
implements SequenceIterable,
EvaluableItem,
Serializable,
InstructionInfoProvider,
Container {
    public static final int EVALUATE_METHOD = 1;
    public static final int ITERATE_METHOD = 2;
    public static final int PROCESS_METHOD = 4;
    protected int staticProperties = -1;
    protected int locationId = -1;
    private Container parentExpression;
    private int[] slotsUsed;

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 2;
        }
        return 1;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x1FF0000;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0xE000;
    }

    public abstract ItemType getItemType(TypeHierarchy var1);

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x10001FF;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        return SingletonIterator.makeIterator(item);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        StringValue stringValue = (StringValue)item;
        if (stringValue == null) {
            return "";
        }
        return stringValue.getStringValue();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        if ((n & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            if (item != null) {
                xPathContext.getReceiver().append(item, this.locationId, 2);
            }
        } else if ((n & 2) != 0) {
            SequenceIterator sequenceIterator = this.iterate(xPathContext);
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            try {
                Item item;
                while ((item = sequenceIterator.next()) != null) {
                    sequenceReceiver.append(item, this.locationId, 2);
                }
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        } else {
            throw new AssertionError((Object)("process() is not implemented in the subclass " + this.getClass()));
        }
    }

    public abstract void display(int var1, PrintStream var2, Configuration var3);

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
    }

    public void setParentExpression(Container container) {
        if (this == container) {
            throw new AssertionError((Object)"Incestuous relationship!");
        }
        this.parentExpression = container;
        if (container instanceof Expression) {
            ((Expression)container).resetStaticProperties();
        }
    }

    public static void setParentExpression(Expression expression, Container container) {
        if (expression != null) {
            expression.setParentExpression(container);
        }
    }

    public void adoptChildExpression(Expression expression) {
        if (expression == null) {
            return;
        }
        if (expression.getParentExpression() == this) {
            return;
        }
        expression.setParentExpression(this);
        if (this.locationId == -1) {
            ExpressionTool.copyLocationInfo(expression, this);
        } else if (expression.locationId == -1) {
            ExpressionTool.copyLocationInfo(this, expression);
        }
        if (this.staticProperties != -1) {
            this.resetStaticProperties();
        }
    }

    public void setLocationId(int n) {
        this.locationId = n;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    public int getLineNumber() {
        if (this.locationId == -1) {
            if (this.parentExpression != null) {
                return this.parentExpression.getLineNumber();
            }
            return -1;
        }
        return this.locationId & 0xFFFFF;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId() {
        if (this.locationId == -1) {
            if (this.parentExpression != null) {
                return this.parentExpression.getSystemId();
            }
            return null;
        }
        Executable executable = this.getExecutable();
        if (executable == null) {
            if (this.parentExpression == null) {
                return null;
            }
            if (this.parentExpression instanceof LocationProvider) {
                return ((LocationProvider)((Object)this.parentExpression)).getSystemId(this.locationId);
            }
            return this.parentExpression.getSystemId();
        }
        LocationMap locationMap = executable.getLocationMap();
        if (locationMap == null) {
            return null;
        }
        return locationMap.getSystemId(this.locationId);
    }

    public final String getPublicId() {
        return null;
    }

    public Executable getExecutable() {
        Expression expression = this;
        for (int i = 0; i < 10000; ++i) {
            Container container = expression.getParentExpression();
            if (container == null) {
                return null;
            }
            if (container == this) {
                int n = this.getLineNumber();
                String string = this.getSystemId();
                throw new IllegalStateException("Expression cannot contain itself: " + this + " at line " + n + " of " + string);
            }
            if (container instanceof GlobalVariable) {
                return ((GlobalVariable)container).getExecutable();
            }
            if (container instanceof Expression) {
                expression = (Expression)container;
                continue;
            }
            return container.getExecutable();
        }
        this.showAncestorExpressions();
        int n = this.getLineNumber();
        throw new IllegalStateException("Expression tree appears to contain a cycle at line " + n);
    }

    public Procedure getContainingProcedure() {
        Expression expression = this;
        for (int i = 0; i < 10000; ++i) {
            Container container = expression.getParentExpression();
            if (container == null) {
                return null;
            }
            if (container == this) {
                int n = this.getLineNumber();
                String string = this.getSystemId();
                throw new IllegalStateException("Expression cannot contain itself: " + this + " at line " + n + " of " + string);
            }
            if (container instanceof Procedure) {
                return (Procedure)container;
            }
            if (container instanceof Expression) {
                expression = (Expression)container;
                continue;
            }
            return null;
        }
        this.showAncestorExpressions();
        int n = this.getLineNumber();
        String string = this.getSystemId();
        throw new IllegalStateException("Expression tree appears to contain a cycle at line " + n + " of " + string);
    }

    public LocationProvider getLocationProvider() {
        Executable executable = this.getExecutable();
        if (executable != null) {
            return executable.getLocationMap();
        }
        if (this.getParentExpression() instanceof LocationProvider) {
            return (LocationProvider)((Object)this.getParentExpression());
        }
        return null;
    }

    public final Expression doPromotion(Expression expression, PromotionOffer promotionOffer) throws XPathException {
        Expression expression2 = expression.promote(promotionOffer);
        if (expression2 != expression) {
            this.adoptChildExpression(expression2);
            this.resetStaticProperties();
        }
        return expression2;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    public final void resetStaticProperties() {
        this.staticProperties = -1;
        Container container = this.parentExpression;
        int n = 0;
        while (container instanceof Expression) {
            ((Expression)container).staticProperties = -1;
            if (n++ > 10000) {
                this.showAncestorExpressions();
                int n2 = this.getLineNumber();
                String string = this.getSystemId();
                throw new IllegalStateException("Expression tree appears to contain a cycle at line " + n2 + " of " + string);
            }
            container = ((Expression)container).parentExpression;
        }
    }

    private void showAncestorExpressions() {
        Expression expression = this;
        for (int i = 0; i < 20; ++i) {
            System.err.println("in " + expression);
            Container container = expression.getParentExpression();
            if (!(container instanceof Expression)) break;
            expression = (Expression)container;
        }
    }

    protected abstract int computeCardinality();

    public int computeSpecialProperties() {
        return 0;
    }

    public int computeDependencies() {
        int n = this.getIntrinsicDependencies();
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            n |= ((Expression)iterator.next()).getDependencies();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        throw new IllegalArgumentException("Invalid replacement");
    }

    public void suppressValidation(int n) {
    }

    public int markTailFunctionCalls(int n, int n2) {
        return 0;
    }

    public int[] getSlotsUsed() {
        if (this.slotsUsed != null) {
            return this.slotsUsed;
        }
        IntHashSet intHashSet = new IntHashSet(10);
        Expression.gatherSlotsUsed(this, intHashSet);
        this.slotsUsed = new int[intHashSet.size()];
        int n = 0;
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            this.slotsUsed[n++] = intIterator.next();
        }
        Arrays.sort(this.slotsUsed);
        return this.slotsUsed;
    }

    private static void gatherSlotsUsed(Expression expression, IntHashSet intHashSet) {
        if (expression instanceof VariableReference) {
            int n;
            Binding binding = ((VariableReference)expression).getBinding();
            if (!binding.isGlobal() && (n = binding.getLocalSlotNumber()) != -1 && !intHashSet.contains(n)) {
                intHashSet.add(n);
            }
        } else {
            Iterator iterator = expression.iterateSubExpressions();
            while (iterator.hasNext()) {
                Expression expression2 = (Expression)iterator.next();
                Expression.gatherSlotsUsed(expression2, intHashSet);
            }
        }
    }

    protected void dynamicError(String string, String string2, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode(string2);
        throw dynamicError;
    }

    protected void typeError(String string, String string2, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode(string2);
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private SourceLocator getSourceLocator() {
        return ExpressionTool.getLocator(this);
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(this.getConstructType());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setColumnNumber(this.getColumnNumber());
        if (this instanceof Assignation) {
            instructionDetails.setObjectNameCode(((Assignation)this).getVariableNameCode());
        }
        return instructionDetails;
    }

    protected int getConstructType() {
        return 2098;
    }

    public boolean hasBadParentPointer() {
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (this != expression.getParentExpression()) {
                System.err.println("Bad parent pointer to " + expression.getParentExpression() + " found in " + expression);
                return true;
            }
            if (!expression.hasBadParentPointer()) continue;
            System.err.println("Found in " + expression);
            return true;
        }
        return false;
    }

    public int getHostLanguage() {
        if (this.parentExpression == null) {
            return 50;
        }
        return this.parentExpression.getHostLanguage();
    }
}

