/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml.esc;

import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriterBase;
import java.io.IOException;
import java.io.Writer;

public final class XMLEscapeWriterASCII
extends XMLEscapeWriterBase
implements XMLEscapeWriter {
    private static final String ENCODING = "ASCII";

    public XMLEscapeWriterASCII(Writer writer) throws NullPointerException {
        super(writer, ENCODING);
    }

    public void writeAttValue(char[] cArray, int n, int n2) throws IOException {
        int n3 = 32;
        for (int i = n; i < n + n2; ++i) {
            n3 = cArray[i];
            if (n3 == 60) {
                this.w.write("&lt;");
                continue;
            }
            if (n3 == 62) {
                this.w.write("&gt;");
                continue;
            }
            if (n3 == 38) {
                this.w.write("&amp;");
                continue;
            }
            if (n3 == 34) {
                this.w.write("&quot;");
                continue;
            }
            if (n3 == 39) {
                this.w.write("&apos;");
                continue;
            }
            if (n3 > 255) {
                this.w.write("&#" + n3 + ";");
                continue;
            }
            if (n3 == 10 || n3 == 13 || n3 == 9) {
                this.w.write(n3);
                continue;
            }
            if (n3 < 32) {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            if (n3 >= 127 && n3 < 160) {
                XMLEscapeWriterASCII.doNothing();
                continue;
            }
            this.w.write(n3);
        }
    }

    public void writeText(char c) throws IOException {
        if (c == '<') {
            this.w.write("&lt;");
        } else if (c == '>') {
            this.w.write("&gt;");
        } else if (c == '&') {
            this.w.write("&amp;");
        } else if (c == '\"') {
            this.w.write("&quot;");
        } else if (c == '\'') {
            this.w.write("&apos;");
        } else if (c > '\u00ff') {
            this.w.write("&#" + c + ";");
        } else if (c == '\n' || c == '\r' || c == '\t') {
            this.w.write(c);
        } else if (c < ' ') {
            XMLEscapeWriterASCII.doNothing();
        } else if (c >= '\u007f' && c < '\u00a0') {
            XMLEscapeWriterASCII.doNothing();
        } else {
            this.w.write(c);
        }
    }

    private static void doNothing() {
    }
}

